% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cma.R
\name{cma}
\alias{cma}
\title{Centered Moving Average}
\usage{
cma(y, order = NULL, silent = TRUE, ...)
}
\arguments{
\item{y}{Vector or ts object, containing data needed to be smoothed.}

\item{order}{Order of centered moving average. If \code{NULL}, then the
function will try to select order of SMA based on information criteria.
See \link[smooth]{sma} for details.}

\item{silent}{If \code{TRUE}, then plot is not produced. Otherwise, there
is a plot...}

\item{...}{Nothing. Needed only for the transition to the new name of variables.}
}
\value{
Object of class "smooth" is returned. It contains the list of the
following values:

\itemize{
\item \code{model} - the name of the estimated model.
\item \code{timeElapsed} - time elapsed for the construction of the model.
\item \code{order} - order of the moving average.
\item \code{nParam} - table with the number of estimated / provided parameters.
If a previous model was reused, then its initials are reused and the number of
provided parameters will take this into account.
\item \code{fitted} - the fitted values, shifted in time.
\item \code{forecast} - NAs, because this function does not produce forecasts.
\item \code{residuals} - the residuals of the SMA / AR model.
\item \code{s2} - variance of the residuals (taking degrees of freedom into
account) of the SMA / AR model.
\item \code{y} - the original data.
\item \code{ICs} - values of information criteria from the respective SMA or
AR model. Includes AIC, AICc, BIC and BICc.
\item \code{logLik} - log-likelihood of the SMA / AR model.
\item \code{lossValue} - Cost function value (for the SMA / AR model).
\item \code{loss} - Type of loss function used in the estimation.
}
}
\description{
Function constructs centered moving average based on state space SMA
}
\details{
If the order is odd, then the function constructs SMA(order) and
shifts it back in time. Otherwise an AR(order+1) model is constructed
with the preset parameters:

phi_i = {0.5,1,1,...,0.5} / order

This then corresponds to the centered MA with 0.5 weight for the
first observation and 0.5 weight for an additional one. e.g. if this is
monthly data and we use order=12, then half of the first January and
half of the new one is taken.

This is not a forecasting tool. This is supposed to smooth the time
series in order to find trend. So don't expect any forecasts from this
function!
}
\examples{

# CMA of specific order
ourModel <- cma(rnorm(118,100,3),order=12)

# CMA of arbitrary order
ourModel <- cma(rnorm(118,100,3))

summary(ourModel)

}
\references{
\itemize{
\item Svetunkov I. (2015 - Inf) "smooth" package for R - series of posts about the underlying
models and how to use them: \url{https://forecasting.svetunkov.ru/en/tag/smooth/}.
\item Svetunkov I. (2017). Statistical models underlying functions of 'smooth'
package for R. Working Paper of Department of Management Science, Lancaster
University 2017:1, 1-52.
}
}
\seealso{
\code{\link[smooth]{es}, \link[smooth]{ssarima}}
}
\author{
Ivan Svetunkov, \email{ivan@svetunkov.ru}
}
\keyword{models}
\keyword{nonlinear}
\keyword{regression}
\keyword{smooth}
\keyword{ts}
\keyword{univar}
