% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gsi.R
\name{gsi}
\alias{gsi}
\title{Vector exponential smoothing model with Group Seasonal Indices}
\usage{
gsi(data, model = "MNM", weights = 1/ncol(data), type = c(3, 2, 1),
  cfType = c("likelihood", "diagonal", "trace"), ic = c("AICc", "AIC",
  "BIC", "BICc"), h = 10, holdout = FALSE, intervals = c("none",
  "conditional", "unconditional", "independent"), level = 0.95,
  bounds = c("admissible", "usual", "none"), silent = c("all", "graph",
  "output", "none"), ...)
}
\arguments{
\item{data}{The matrix with data, where series are in columns and
observations are in rows.}

\item{model}{The type of seasonal ETS model. Currently only "MMM" is available.}

\item{weights}{The vector of weights for seasonal indices of the length equal to
the number of time series in the model.}

\item{type}{Type of the GSI model. Can be "Model 1", "Model 2" or "Model 3".}

\item{cfType}{Type of Cost Function used in optimization. \code{cfType} can
be:
\itemize{
\item \code{likelihood} - which assumes the minimisation of the determinant
of the covariance matrix of errors between the series. This implies that the
series could be correlated;
\item \code{diagonal} - the covariance matrix is assumed to be diagonal with
zeros off the diagonal. The determinant of this matrix is just a product of
variances. This thing is minimised in this situation in logs.
\item \code{trace} - the trace of the covariance matrix. The sum of variances
is minimised in this case.
}}

\item{ic}{The information criterion used in the model selection procedure.}

\item{h}{Length of forecasting horizon.}

\item{holdout}{If \code{TRUE}, holdout sample of size \code{h} is taken from
the end of the data.}

\item{intervals}{Type of intervals to construct. NOT AVAILABLE YET!

This can be:

\itemize{
\item \code{none}, aka \code{n} - do not produce prediction
intervals.
\item \code{conditional}, \code{c} - produces multidimensional elliptic
intervals for each step ahead forecast.
\item \code{unconditional}, \code{u} - produces separate bounds for each series
based on ellipses for each step ahead. These bounds correspond to min and max
values of the ellipse assuming that all the other series but one take values in
the centre of the ellipse. This leads to less accurate estimates of bounds
(wider intervals than needed), but these could still be useful.
\item \code{independent}, \code{i} - produces intervals based on variances of
each separate series. This does not take vector structure into account.
}
The parameter also accepts \code{TRUE} and \code{FALSE}. The former means that
conditional intervals are constructed, while the latter is equivalent to
\code{none}.}

\item{level}{Confidence level. Defines width of prediction interval.}

\item{bounds}{What type of bounds to use in the model estimation. The first
letter can be used instead of the whole word. Currently only \code{"admissible"}
bounds are available.}

\item{silent}{If \code{silent="none"}, then nothing is silent, everything is
printed out and drawn. \code{silent="all"} means that nothing is produced or
drawn (except for warnings). In case of \code{silent="graph"}, no graph is
produced. If \code{silent="legend"}, then legend of the graph is skipped.
And finally \code{silent="output"} means that nothing is printed out in the
console, but the graph is produced. \code{silent} also accepts \code{TRUE}
and \code{FALSE}. In this case \code{silent=TRUE} is equivalent to
\code{silent="all"}, while \code{silent=FALSE} is equivalent to
\code{silent="none"}. The parameter also accepts first letter of words ("n",
"a", "g", "l", "o").}

\item{...}{Other non-documented parameters. For example \code{FI=TRUE} will
make the function also produce Fisher Information matrix, which then can be
used to calculated variances of smoothing parameters and initial states of
the model.}
}
\value{
Object of class "vsmooth" is returned. It contains the following list of
values:
\itemize{
\item \code{model} - The name of the fitted model;
\item \code{timeElapsed} - The time elapsed for the construction of the model;
\item \code{states} - The matrix of states with components in columns and time in rows;
\item \code{persistence} - The persistence matrix;
\item \code{coefficients} - The vector of all the estimated coefficients;
\item \code{initial} - The initial values of the non-seasonal components;
\item \code{initialSeason} - The initial values of the seasonal components;
\item \code{nParam} - The number of estimated parameters;
\item \code{actuals} - The matrix with the original data;
\item \code{fitted} - The matrix of the fitted values;
\item \code{holdout} - The matrix with the holdout values (if \code{holdout=TRUE} in
the estimation);
\item \code{residuals} - The matrix of the residuals of the model;
\item \code{Sigma} - The covariance matrix of the errors (estimated with the correction
for the number of degrees of freedom);
\item \code{forecast} - The matrix of point forecasts;
\item \code{PI} - The bounds of the prediction intervals;
\item \code{intervals} - The type of the constructed prediction intervals;
\item \code{level} - The level of the confidence for the prediction intervals;
\item \code{ICs} - The values of the information criteria;
\item \code{logLik} - The log-likelihood function;
\item \code{cf} - The value of the cost function;
\item \code{cfType} - The type of the used cost function;
\item \code{accuracy} - the values of the error measures. Currently not available.
\item \code{FI} - Fisher information if user asked for it using \code{FI=TRUE}.
}
}
\description{
Function constructs VES model with restrictions on seasonal indices
}
\details{
Function estimates VES in a form of the Single Source of Error state space
model, restricting the seasonal indices. The model is based on \link[smooth]{ves}

In case of multiplicative model, instead of the vector y_t we use its logarithms.
As a result the multiplicative model is much easier to work with.
}
\examples{

initialSeason <- runif(12,-1,1)
Y <- sim.ves("AAA", obs=120, nSeries=2, frequency=12, initial=c(10,0),
             initialSeason=initialSeason-mean(initialSeason),
             persistence=c(0.06,0.05,0.2), mean=0, sd=0.03)
Y$data <- exp(Y$data)

# The simplest model applied to the data with the default values
gsi(Y, h=10, holdout=TRUE, interval="u")

# An example with MASS package and correlated errors
\dontrun{library(MASS)}
\dontrun{Y <- sim.ves("AAA", obs=120, nSeries=2, frequency=12,
         initial=c(5,0), initialSeason=initialSeason-mean(initialSeason),
         persistence=c(0.02,0.01,0.1), randomizer="mvrnorm", mu=c(0,0),
         Sigma=matrix(c(0.2,0.1,0.1,0.1),2,2))}
\dontrun{Y$data <- exp(Y$data)}
\dontrun{gsi(Y, h=10, holdout=TRUE, interval="u", silent=FALSE)}

}
\references{
\itemize{
\item de Silva A,, Hyndman R.J. and Snyder, R.D. (2010). The vector
innovations structural time series framework: a simple approach to
multivariate forecasting. Statistical Modelling, 10 (4), pp.353-374
\item Hyndman, R.J., Koehler, A.B., Ord, J.K., and Snyder, R.D. (2008)
Forecasting with exponential smoothing: the state space approach,
Springer-Verlag. \url{http://www.exponentialsmoothing.net}.
\item Lütkepohl, H. (2005). New Introduction to Multiple Time Series
Analysis. New introduction to Multiple Time Series Analysis. Berlin,
Heidelberg: Springer Berlin Heidelberg.
\url{https://doi.org/10.1007/978-3-540-27752-1}
}
}
\seealso{
\code{\link[smooth]{es}, \link[forecast]{ets}}
}
\author{
Ivan Svetunkov, \email{ivan@svetunkov.ru}
}
\keyword{models}
\keyword{multivariate}
\keyword{nonlinear}
\keyword{regression}
\keyword{ts}
