% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sof.bohachevsky.n1.R
\name{makeBohachevskyN1Function}
\alias{makeBohachevskyN1Function}
\title{Bohachevsky function N. 1}
\usage{
makeBohachevskyN1Function(dimensions)
}
\arguments{
\item{dimensions}{[\code{integer(1)}]\cr
Size of corresponding parameter space.}
}
\value{
[\code{smoof_single_objective_function}]
}
\description{
Highly multimodal single-objective test function. The mathematical formula is
given by
\deqn{f(\mathbf{x}) = \sum_{i = 1}^{n - 1} (\mathbf{x}_i^2 + 2 \mathbf{x}_{i + 1}^2 - 0.3\cos(3\pi\mathbf{x}_i) - 0.4\cos(4\pi\mathbf{x}_{i + 1}) + 0.7)}
with box-constraints \eqn{\mathbf{x}_i  \in [-100, 100]} for \eqn{i = 1, \ldots, n}.
The multimodality will be visible by \dQuote{zooming in} in the plot.
}
\references{
I. O. Bohachevsky, M. E. Johnson, M. L. Stein, General Simulated
Annealing for Function Optimization, Technometrics, vol. 28, no. 3, pp. 209-217, 1986.
}

