% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/sof.mpm2.R
\name{makeMPM2Function}
\alias{makeMPM2Function}
\title{Generator for function with multiple peaks following the multiple peaks model 2.}
\usage{
makeMPM2Function(n.peaks, dimension, topology, seed)
}
\arguments{
\item{n.peaks}{[\code{integer(1)}]\cr
Desired number of peaks, i. e., number of (local) optima.}

\item{dimension}{[\code{integer(1)}]\cr
Problem dimension.}

\item{topology}{[\code{integer(1)}]\cr
Type of topology. Possible values are \dQuote{random} and \dQuote{funnel}.}

\item{seed}{[\code{integer(1)}]\cr
Seed for the random numbers generator.}
}
\value{
[\code{smoof_single_objective_function}]
}
\description{
Generator for function with multiple peaks following the multiple peaks model 2.
}
\examples{
\dontrun{
fn = makeMPM2Function(n.peaks = 10L, dimension = 2L, topology = "funnel", seed = 123)
if (require(plot3D)) {
  plot3D(fn)
}
}
\dontrun{
fn = makeMPM2Function(n.peaks = 5L, dimension = 2L, topology = "random", seed = 134)
plot(fn, render.levels = TRUE)
}
}
\author{
\R interface by Jakob Bossek. Original python code
provided by the Simon Wessing.
}
\references{
See the \href{https://ls11-www.cs.uni-dortmund.de/_media/techreports/tr15-01.pdf}{technical report}
of multiple peaks model 2 for an in-depth description of the underlying algorithm.
}

