% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim_rct_biomarker.R
\name{sim_rct_biomarker}
\alias{sim_rct_biomarker}
\title{Simulate a randomized clinical trial with biomarkers}
\usage{
sim_rct_biomarker(n = 50, p = 100, p_prog = 5, p_pred = 5, p_both = 5,
  v_trt = 0.4, v_prog = 0.2, v_pred = 0.2, v_err = 0.2, corr = NULL,
  family = "gaussian", ...)
}
\arguments{
\item{n}{Number of subjects.}

\item{p}{Number of biomarkers.}

\item{p_prog}{Number of biomarkers with prognostic effects only.}

\item{p_pred}{Number of biomarkers with predictive effects only.}

\item{p_both}{Number of biomarkers with both prognostic and predictive effects}

\item{v_trt}{Variance of response due to treatment.}

\item{v_prog}{Variance of response due to prognostic effects.}

\item{v_pred}{Variance of response due to predictive effects.}

\item{v_err}{Variance of response due to random noise.}

\item{corr}{Autocorrelation parameter between biomarkers, default is \code{NULL}.}

\item{family}{The distribution family for response variable, can be ``gaussian'',
or ``binomial''. Default is ``gaussian''.}

\item{...}{further arguments passed to or from other methods.}
}
\value{
A list containing several variables.
       \item{T}{Treatment status in 1 or -1 values.}
       \item{X}{Biomarkers.}
       \item{W}{Hadamard product of treatment and biomarkers.}
       \item{M}{Model matrix - binding of \code{T}, \code{X}, and \code{W}.}
       \item{Y}{Response.}
       \item{Y0}{Response without error.}
       \item{tau}{Treatment effect.}
       \item{beta}{Prognostic effects.}
       \item{gamma}{Predictive effects.}
       \item{theta}{All effects corresponding to \code{M}.}
}
\description{
\code{sim_rct_biomarker} is used to simulate clinical trial data with
specified treatment, prognostic, and predictive effect sizes.
}
\examples{
sim <- sim_rct_biomarker(n = 1e5)
var(sim$T * sim$tau)
var(sim$X \%*\% sim$beta)
var(sim$W \%*\% sim$gamma)

}
\references{
\insertRef{ma2019structural}{smog}
}
\author{
Chong Ma \email{chong.ma@yale.edu}, Kevin Galinsky \email{Kevin.Galinsky@takeda.com}.
}
