% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/optimal_ubpop-plot.R
\name{plot.smerc_optimal_ubpop}
\alias{plot.smerc_optimal_ubpop}
\title{Plot object of class \code{smerc_optimal_ubpop}.}
\usage{
\method{plot}{smerc_optimal_ubpop}(x, ..., method = "all")
}
\arguments{
\item{x}{An object of class \code{smerc_optimal_ubpop}.}

\item{...}{Not used}

\item{method}{The method to plot. The default is \code{"all"}.
The other valid options are \code{"elbow"} and \code{"gini"}.}
}
\description{
Plot results of \code{\link{optimal_ubpop}}. This is only meant for a visual
summary of the results. Users will need to access the elements of the \code{smerc_optimal_ubpop} object \code{x}
if they want to create a custom plot.
}
\examples{
data(nydf)
coords <- with(nydf, cbind(longitude, latitude))
ubpop_stats <- optimal_ubpop(
  coords = coords, cases = nydf$cases,
  pop = nydf$pop, nsim = 49,
  ubpop = seq(0.05, 0.5, by = 0.05)
)
\dontrun{
plot(ubpop_stats)
}
plot(ubpop_stats, method = "elbow")
plot(ubpop_stats$ubpop_seq, ubpop_stats$elbow_method$stats)
plot(ubpop_stats, method = "gini")
plot(ubpop_stats$ubpop_seq, ubpop_stats$gini_method$stats)
}
\seealso{
\code{\link{optimal_ubpop}}
}
