% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sm2.R
\name{sm2_keyexchange_1ab}
\alias{sm2_keyexchange_1ab}
\alias{sm2_keyexchange_2a}
\alias{sm2_keyexchange_2b}
\title{SM2 Key Exchange}
\usage{
sm2_keyexchange_1ab(klen, id, private_key)

sm2_keyexchange_2a(id, private_key, private_key_r, recive_bytes)

sm2_keyexchange_2b(id, private_key, private_key_r, recive_bytes)
}
\arguments{
\item{klen}{the key length, must be an integer}

\item{id}{id of A or B, must be a raw vector}

\item{private_key}{private key of A or B represented as a hexadecimal string}

\item{private_key_r}{temp private_key of A or B}

\item{recive_bytes}{for A or B, the recived data from B or A}
}
\value{
\describe{
  \item{\link{sm2_keyexchange_1ab}}{returns a list, `data` for the raw data sent to B(for A) or A(for B), `private_key_r` for the temporary private key}
  \item{\link{sm2_keyexchange_2a}}{returns a list, `k` for the key of length `klen`, `s12` for the sm3 hash in asn.1 encoding}
  \item{\link{sm2_keyexchange_2b}}{returns a list, `k` for the key of length `klen`, `s12` for the sm3 hash in asn.1 encoding}
}
}
\description{
SM2 is an asymmetric encryption algorithm, therefore, it can also be used for
key agreement or key exchange. If A and B want to generate a recognized key
for encryption or authentication, this algorithm can ensure that the key
itself will not be transmitted through untrusted channels, and the private
keys of A and B will not be disclosed. Even if an attacker intercepts the
data exchanged by A and B, they cannot calculate the key agreed upon by A and B.
}
\examples{
## Step 1
klen <- 16
id_a <- "a@company.com" |> charToRaw()
id_b <- "b@company.com" |> charToRaw()
private_key_a <- sm2_gen_keypair()$private_key
private_key_b <- sm2_gen_keypair()$private_key
step_1_a <- sm2_keyexchange_1ab(klen, id_a, private_key_a)
step_1_b <- sm2_keyexchange_1ab(klen, id_b, private_key_b)

## Step 2
step_2_a <- sm2_keyexchange_2a(id_a, private_key_a, step_1_a$private_key_r, step_1_b$data)
step_2_b <- sm2_keyexchange_2b(id_b, private_key_b, step_1_b$private_key_r, step_1_a$data)
step_2_a$k
step_2_b$k
}
