% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sm2.R
\name{sm2_encrypt_asna1}
\alias{sm2_encrypt_asna1}
\alias{sm2_decrypt_asna1}
\title{SM2 Encrypt/Decrypt - asn.1}
\usage{
sm2_encrypt_asna1(data, public_key)

sm2_decrypt_asna1(data, private_key)
}
\arguments{
\item{data}{data to be encrypted or decrypted, must be a raw vector}

\item{public_key}{a public key represented as a hexadecimal string}

\item{private_key}{a private key represented as a hexadecimal string}
}
\value{
\describe{
  \item{\link{sm2_encrypt_asna1}}{returns a raw vector of the cipher text in the asn.1 encoding}
  \item{\link{sm2_decrypt_asna1}}{returns a raw vector of the plain text}
}
}
\description{
According to the usage specifications of the SM2 algorithm, the encrypted
data should be encoded using ASN.1, specifically including XCoordinate,
YCoordinate, HASH, and CipherText. Among them, XCoordinate and YCoordinate
each occupy 32 bytes, HASH occupies 32 bytes, and CipherText is the same
length as the plaintext, plus a one-byte "04" identifier. After SM2
encryption and ASN.1 encoding, the ciphertext data will be 97 bytes longer
than the original plaintext data.
}
\examples{
## encrypt and decrypt as asn.1
keypair <- sm2_gen_keypair()
private_key <- keypair$private_key
public_key <- keypair$public_key
data <- 'abc' |> charToRaw()
enc <- sm2_encrypt_asna1(data, public_key)
enc
dec <- sm2_decrypt_asna1(enc, private_key)
dec
}
