% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/smbinning.R
\name{smbinning.sumiv}
\alias{smbinning.sumiv}
\title{Information value Summary}
\usage{
smbinning.sumiv(df, y)
}
\arguments{
\item{df}{A data frame.}

\item{y}{Binary response variable (0,1). Integer (\code{int}) is required.
Name of \code{y} must not have a dot. Name "default" is not allowed.}
}
\value{
The command \code{smbinning.sumiv} generates a table that lists each characteristic 
with its corresponding IV for those where the calculation is possible, otherwise it will generate a 
missing value (\code{NA}).
}
\description{
It gives the user the ability to calculate, in one step, the IV for each characteristic of the dataset.
This function also shows a progress bar so the user can see the status of the process.
}
\examples{
# Package loading and data exploration
library(smbinning) # Load package and its data
data(chileancredit) # Load smbinning sample dataset (Chilean Credit)
 
# Training and testing samples (Just some basic formality for Modeling) 
chileancredit.train=subset(chileancredit,FlagSample==1)
chileancredit.test=subset(chileancredit,FlagSample==0)
 
# Summary IV application
sumivt=smbinning.sumiv(chileancredit.train,y="FlagGB")
sumivt # Display table with IV by characteristic
}

