% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/noise.R
\name{clean_noise}
\alias{clean_noise}
\title{Noise cleaning wrapper}
\usage{
clean_noise(dataset, method, class_attr = "Class", ...)
}
\arguments{
\item{dataset}{we want to clean noisy instances on}

\item{method}{selected method of noise cleaning}

\item{class_attr}{\code{character}. Indicates the class attribute or
attributes from \code{dataset}. Must exist in it.}

\item{...}{Further arguments for \code{method}}
}
\value{
The treated dataset (either with noisy instances replaced or erased)
}
\description{
Noise cleaning wrapper
}
\examples{
library("smartdata")
data(iris0, package = "imbalance")

super_iris <- clean_noise(iris, method = "AENN", class_attr = "Species", k = 3)
super_iris <- clean_noise(iris, "GE", class_attr = "Species", k = 5, relabel_th = 2)
super_iris <- clean_noise(iris, "HARF", class_attr = "Species",
                          num_folds = 10, agree_level = 0.7, num_trees = 5)

\donttest{
super_iris <- clean_noise(iris0, "TomekLinks")
super_iris <- clean_noise(iris, "hybrid", class_attr = "Species",
                          consensus = FALSE, action = "repair")
super_iris <- clean_noise(iris, "Mode", class_attr = "Species", type = "iterative",
                          action = "repair", epsilon = 0.05,
                          num_iterations = 200, alpha = 1, beta = 1)
super_iris <- clean_noise(iris, "INFFC", class_attr = "Species", consensus = FALSE,
                          prob_noisy = 0.2, num_iterations = 3, k = 5, threshold = 0)
super_iris <- clean_noise(iris, "IPF", class_attr = "Species", consensus = FALSE,
                          num_folds = 3, prob_noisy = 0.2,
                          prob_good = 0.5, num_iterations = 3)
super_iris <- clean_noise(iris, "ORBoost", class_attr = "Species",
                          num_boosting = 20, threshold = 11, num_adaboost = 20)
super_iris <- clean_noise(iris, "PF", class_attr = "Species", prob_noisy = 0.01,
                          num_iterations = 5, prob_good = 0.5, theta = 0.8)
super_iris <- clean_noise(iris, "C45robust", class_attr = "Species", num_folds = 5)
}
}
