% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/slm-main.R
\name{cov_select}
\alias{cov_select}
\title{Covariances Selection}
\usage{
cov_select(epsilon, model_selec, plot = FALSE)
}
\arguments{
\item{epsilon}{an univariate process.}

\item{model_selec}{a vector with the positive lags of the selected autocovariance terms. The variance (lag = 0) is automatically selected.}

\item{plot}{logical. By default, \code{plot = FALSE}. If \code{plot = TRUE} the ACF of the process is plotted.}
}
\value{
This function returns the estimated autocovariance terms.
 \item{model_selec}{the vector with the positive lag of the selected autocovariance terms.}
 \item{cov_st}{the vector of the selected autocovariances.}
}
\description{
Allows the user to select the lags of the autocovariance terms of the process to be kept.
}
\details{
In the framework of \code{slm}, this is a manual method for estimating the covariance matrix of the error process
 by only selecting some autocovariance terms from the residual autocovariances.
}
\examples{
x = arima.sim(list(ar=c(0.2,0.1,0.25)),1000)
cov_select(x, c(1,3,5))
}
\references{
E. Caron, J. Dedecker and B. Michel (2019). Linear regression with stationary errors: the R package slm. \emph{arXiv preprint arXiv:1906.06583}.
 \url{https://arxiv.org/abs/1906.06583}.
}
