% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/str_pos.R
\name{str_find}
\alias{str_find}
\title{Find partial matching and close distance elements in strings}
\usage{
str_find(string, pattern, precision = 2, partial = 0,
  verbose = FALSE)
}
\arguments{
\item{string}{Character vector with string elements.}

\item{pattern}{String that should be matched against the elements of \code{string}.}

\item{precision}{Maximum distance ("precision") between two string elements,
which is allowed to treat them as similar or equal. Smaller values mean
less tolerance in matching.}

\item{partial}{Activates similar matching (close distance strings) for parts (substrings)
of the \code{string}. Following values are accepted:
\itemize{
  \item 0 for no partial distance matching
  \item 1 for one-step matching, which means, only substrings of same length as \code{pattern} are extracted from \code{string} matching
  \item 2 for two-step matching, which means, substrings of same length as \code{pattern} as well as strings with a slightly wider range are extracted from \code{string} matching
}
Default value is 0. See 'Details' for more information.}

\item{verbose}{Logical; if \code{TRUE}, the progress bar is displayed when computing the distance matrix.
Default in \code{FALSE}, hence the bar is hidden.}
}
\value{
A numeric vector with index position of elements in \code{string} that
   partially match or are similar to \code{pattern}. Returns \code{-1} if no
   match was found.
}
\description{
This function finds the element indices of partial matching or
   similar strings in a character vector. Can be used to find exact or
   slightly mistyped elements in a string vector.
}
\details{
\strong{Computation Details}
  \cr \cr
  Fuzzy string matching is based on regular expressions, in particular
  \code{grep(pattern = "(<pattern>){~<precision>}", x = string)}. This
  means, \code{precision} indicates the number of chars inside \code{pattern}
  that may differ in \code{string} to cosinder it as "matching". The higher
  \code{precision} is, the more tolerant is the search (i.e. yielding more
  possible matches). Furthermore, the higher the value for \code{partial}
  is, the more matches may be found.
  \cr \cr
  \strong{Partial Distance Matching}
  \cr \cr
  For \code{partial = 1}, a substring of \code{length(pattern)} is extracted
  from \code{string}, starting at position 0 in \code{string} until
  the end of \code{string} is reached. Each substring is matched against
  \code{pattern}, and results with a maximum distance of \code{precision}
  are considered as "matching". If \code{partial = 2}, the range
  of the extracted substring is increased by 2, i.e. the extracted substring
  is two chars longer and so on.
}
\note{
This function does \emph{not} return the position of a matching string \emph{inside}
   another string, but the element's index of the \code{string} vector, where
   a (partial) match with \code{pattern} was found. Thus, searching for "abc" in
   a string "this is abc" will not return 9 (the start position of the substring),
   but 1 (the element index, which is always 1 if \code{string} only has one element).
}
\examples{
string <- c("Hello", "Helo", "Hole", "Apple", "Ape", "New", "Old", "System", "Systemic")
str_find(string, "hel")   # partial match
str_find(string, "stem")  # partial match
str_find(string, "R")     # no match
str_find(string, "saste") # similarity to "System"

# finds two indices, because partial matching now
# also applies to "Systemic"
str_find(string,
        "sytsme",
        partial = 1)

# finds partial matching of similarity
str_find("We are Sex Pistols!", "postils")

}
\seealso{
\code{\link{group_str}}
}
