% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/big_mark.R
\name{big_mark}
\alias{big_mark}
\alias{prcn}
\title{Format numbers}
\usage{
big_mark(x, big.mark = ",", ...)

prcn(x)
}
\arguments{
\item{x}{A vector or data frame. All numeric inputs (including numeric character)
vectors) will be prettified. For \code{prcn()}, a number between
0 and 1, or a vector or data frame with such numbers.}

\item{big.mark}{Character, used as mark between every 3 decimals before the decimal point.}

\item{...}{Other arguments passed down to the \code{\link{prettyNum}}-function.}
}
\value{
For \code{big_mark()}, a prettified \code{x} as character, with big marks.
   For \code{prcn}, a character vector with a percentage number.
}
\description{
\code{big_mark()} formats large numbers with big marks, while
   \code{prcn()} converts a numeric scalar between 0 and 1 into a character
   vector, representing the percentage-value.
}
\examples{
# simple big mark
big_mark(1234567)

# big marks for several values at once, mixed numeric and character
big_mark(c(1234567, "55443322"))

# pre-defined width of character output
big_mark(c(1234567, 55443322), width = 15)

# convert numbers into percentage, as character
prcn(0.2389)
prcn(c(0.2143887, 0.55443, 0.12345))

dat <- data.frame(
  a = c(.321, .121, .64543),
  b = c("a", "b", "c"),
  c = c(.435, .54352, .234432)
)
prcn(dat)

}
