% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/is_empty.R
\name{empty_cols}
\alias{empty_cols}
\alias{empty_rows}
\alias{remove_empty_cols}
\alias{remove_empty_rows}
\title{Return or remove variables or observations that are completely missing}
\usage{
empty_cols(x)

empty_rows(x)

remove_empty_cols(x)

remove_empty_rows(x)
}
\arguments{
\item{x}{A data frame.}
}
\value{
For \code{empty_cols} and \code{empty_rows}, a numeric (named) vector
          with row or column indices of those variables that completely have
          missing values.
          \cr \cr
          For \code{remove_empty_cols} and \code{remove_empty_rows}, a
          \code{\link[tibble]{tibble}} with "empty" columns or rows removed.
}
\description{
These functions check which rows or columns of a data frame completely
               contain missing values, i.e. which observations or variables
               completely have missing values, and either 1) returns their
               indices; or 2) removes them from the data frame.
}
\examples{
tmp <- data.frame(a = c(1, 2, 3, NA, 5),
                  b = c(1, NA, 3, NA , 5),
                  c = c(NA, NA, NA, NA, NA),
                  d = c(1, NA, 3, NA, 5))

tmp

empty_cols(tmp)
empty_rows(tmp)

remove_empty_cols(tmp)
remove_empty_rows(tmp)

}
