#' @title Convert labelled vectors into normal classes
#' @name unlabel
#'
#' @description This function converts \code{\link[haven]{labelled}} class vectors
#'                into a generic data format, which means that simply all \code{\link[haven]{labelled}}
#'                class attributes will be removed, so all vectors / variables will most
#'                likely become \code{\link{atomic}}. Additionally, \code{tbl_df} and
#'                \code{tbl} class attributes will be removed from data frames, and
#'                a \code{\link{lbl_df}} class attribute will be added. See 'Note'.
#'
#' @param x A data frame, which contains \code{\link[haven]{labelled}} class
#'          vectors or a single vector of class \code{labelled}.
#'
#' @return A data frame or single vector (depending on \code{x}) with common object classes.
#'
#' @note This function is deprecated. Please use \CRANpkg{sjlabelled} for
#'       labelled data functions now.
#'
#' @importFrom utils txtProgressBar setTxtProgressBar
#' @export
unlabel <- function(x) {
  .Deprecated("unlabel", package = "sjlabelled", msg = "This function will be removed in future versions of sjmisc and has been moved to package 'sjlabelled'. Please use sjlabelled::unlabel() instead.")

  # check if complete data frame or only single
  # vector should be converted
  if (is.data.frame(x)) {
    # create progress bar
    pb <- utils::txtProgressBar(min = 0, max = ncol(x), style = 3)
    # tell user...
    message("Converting labelled-classes. Please wait...\n")
    for (i in seq_len(ncol(x))) {
      # remove labelled class
      if (is_labelled(x[[i]])) x[[i]] <- unclass(x[[i]])
      # update progress bar
      utils::setTxtProgressBar(pb, i)
    }
    close(pb)
    # remove redundant class attributes
    class(x) <- c("lbl_df", "data.frame")
  } else {
    # remove labelled class
    if (is_labelled(x)) x <- unclass(x)
  }

  x
}
