% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ref_lvl.R
\name{ref_lvl}
\alias{ref_lvl}
\title{Change reference level of (numeric) factors}
\usage{
ref_lvl(x, ..., value = NULL)
}
\arguments{
\item{x}{A vector or data frame.}

\item{...}{Optional, unquoted names of variables. Required, if \code{x} is
a data frame (and no vector) and only selected variables
from \code{x} should be processed. You may also use functions like
\code{:} or dplyr's \code{\link[dplyr]{select_helpers}}.
The latter must be stated as formula (i.e. beginning with \code{~}).
See 'Examples' or \href{../doc/design_philosophy.html}{package-vignette}.}

\item{value}{Numeric, the new reference level.}
}
\value{
\code{x} with new reference level. If \code{x}
          is a data frame, the complete data frame \code{x} will be returned,
          where variables specified in \code{...} will be re-leveled;
          if \code{...} is not specified, applies to all variables in the
          data frame.
}
\description{
Changes the reference level of numeric factor. See 'Details'.
}
\details{
Unlike \code{\link[stats]{relevel}}, this function a) only accepts
           numeric factors and b) changes the reference level by recoding
           the factor's values using the \code{\link{rec}} function. Hence,
           all values from lowest up to the reference level indicated by
           \code{value} are recoded, with \code{value} starting as lowest
           factor value. See 'Examples'.
}
\examples{
data(efc)
x <- to_factor(efc$e42dep)
str(x)
frq(x)

x <- ref_lvl(x, value = 3)
str(x)
frq(x)

library(dplyr)
dat <- efc \%>\%
  select(c82cop1, c83cop2, c84cop3) \%>\%
  to_factor()

str(dat)
ref_lvl(dat, c82cop1, c83cop2, value = 2) \%>\% str()

}
\seealso{
\code{\link{to_factor}} to convert numeric vectors into factors;
           \code{\link{rec}} to recode variables.
}
