% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/mwu.R
\name{mwu}
\alias{mwu}
\title{Mann-Whitney-U-Test}
\usage{
mwu(x, grp, distribution = "asymptotic", weights = NULL)
}
\arguments{
\item{x}{Numeric vector / variable, where the Mann-Whitney-U-Test should be applied to}

\item{grp}{Grouping variable indicating the groups that should be used for comparison}

\item{distribution}{Indicates how the null distribution of the test statistic should be computed.
May be one of \code{"exact"}, \code{"approximate"} or \code{"asymptotic"}
(default). See \code{\link[coin]{wilcox_test}} for details.}

\item{weights}{Integer valued weights for the observations. By default,
this is \code{NULL}.}
}
\value{
(Invisibly) returns a data frame with U, p and Z-values for each group-comparison
        as well as effect-size r; additionally, group-labels and groups' n's are
        also included.
}
\description{
This function performs a Mann-Whitney-U-Test (or \code{Wilcoxon rank sum test},
               see \code{\link{wilcox.test}} and \code{\link[coin]{wilcox_test}})
               for \code{x}, for each group indicated by \code{grp}. If \code{grp}
               has more than two categories, a comparison between each combination of
               two groups is performed. \cr \cr
               The function reports U, p and Z-values as well as effect size r
               and group-rank-means.
}
\note{
This function calls the \code{\link[coin]{wilcox_test}} with formula. If \code{grp}
        has more than two groups, additionally a Kruskal-Wallis-Test (see \code{\link{kruskal.test}})
        is performed. \cr \cr
        Interpretation of effect sizes, as a rule-of-thumb:
        \itemize{
         \item small effect >= 0.1
         \item medium effect >= 0.3
         \item large effect >= 0.5
       }
}
\examples{
data(efc)
# Mann-Whitney-U-Tests for elder's age by elder's dependency.
mwu(efc$e17age, efc$e42dep)
}

