% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/sjImportSPSS.R
\name{set_var_labels}
\alias{set_var_labels}
\title{Attach variable label(s) to variables}
\usage{
set_var_labels(x, lab, attr.string = NULL)
}
\arguments{
\item{x}{a variable (vector), \code{list} of variables or a \code{data.frame}
where variables labels should be attached.}

\item{lab}{If \code{x} is a vector (single variable), use a single character string with
the variable label for \code{x}. If \code{x} is a data frame, use a
vector with character labels of same length as \code{ncol(x)}.
Use \code{lab = ""} to remove labels-attribute from \code{x}, resp.
set any value of vector \code{lab} to \code{""} to remove specific variable
label attributes from a data frame's variable.}

\item{attr.string}{The attribute string for the variable label. \strong{Note:}
Usually, this parameter should be ignored. It is only used internally
for the \code{\link{write_spss}} and \code{\link{write_stata}} functions.}
}
\value{
\code{x}, with attached variable label attribute(s), which contains the
          variable name(s); or with removed label-attribute if
           \code{lab = ""}.
}
\description{
This function sets variable labels to a single variable or to
               a set of variables in a \code{data.frame} or \code{list}-object.
               To each variable, the attribute \code{"label"} or \code{"variable.label"}
               with the related variable name is attached. Most functions of the
               \emph{sjPlot} package can automatically retrieve the variable
               name to use it as axis labels or plot title (see 'Details').
}
\details{
See 'Details' in \code{\link{get_val_labels}}
}
\note{
See 'Note' in \code{\link{get_val_labels}}
}
\examples{
# sample data set, imported from SPSS.
data(efc)

\dontrun{
library(sjPlot)
sjt.frq(efc$e42dep)
sjt.frq(data.frame(efc$e42dep, efc$e16sex))}


# manually set value and variable labels
dummy <- sample(1:4, 40, replace=TRUE)
dummy <- set_val_labels(dummy, c("very low", "low", "mid", "hi"))
dummy <- set_var_labels(dummy, "Dummy-variable")
# auto-detection of value labels by default, auto-detection of
# variable labels if parameter "title" set to NULL.
\dontrun{
library(sjPlot)
sjp.frq(dummy, title = NULL)}


# Set variable labels for data frame
dummy <- data.frame(a = sample(1:4, 10, replace = TRUE),
                    b = sample(1:4, 10, replace = TRUE),
                    c = sample(1:4, 10, replace = TRUE))
dummy <- set_var_labels(dummy,
                        c("Variable A",
                          "Variable B",
                          "Variable C"))
str(dummy)

# remove one variable label
dummy <- set_var_labels(dummy,
                        c("Variable A",
                          "",
                          "Variable C"))
str(dummy)


# setting same variable labels to multiple vectors

# create a set of dummy variables
dummy1 <- sample(1:4, 40, replace=TRUE)
dummy2 <- sample(1:4, 40, replace=TRUE)
dummy3 <- sample(1:4, 40, replace=TRUE)
# put them in list-object
dummies <- list(dummy1, dummy2, dummy3)
# and set variable labels for all three dummies
dummies <- set_var_labels(dummies, c("First Dummy", "2nd Dummy", "Third dummy"))
# see result...
get_var_labels(dummies)
}
\seealso{
The sjPlot manual on \href{http://www.strengejacke.de/sjPlot/datainit/}{data initialization} or
           \href{http://www.strengejacke.de/sjPlot/view_spss/}{inspecting (SPSS imported) data frames} for
           more details; \code{\link{set_val_labels}} to manually set value labels or \code{\link{get_var_labels}}
           to get variable labels.
}

