% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/sjImportSPSS.R
\name{add_labels}
\alias{add_labels}
\title{Set back value and variable labels to subsetted data frames}
\usage{
add_labels(df_new, df_origin = NULL)
}
\arguments{
\item{df_new}{the new, subsetted data frame.}

\item{df_origin}{the original data frame where the subset (\code{df_new}) stems from;
use \code{NULL}, if value and variable labels from \code{df_new} should be removed.}
}
\value{
Returns \code{df_new} with either removed value and variable label attributes
          (if \code{df_origin} was \code{NULL}) or with added value and variable label
          attributes (if \code{df_origin} was the original subsetted data frame).
}
\description{
Subsetting-functions usually drop value and variable labels from
               subsetted data frames (if the original data frame has value and variable
               label attributes). This function adds back these value and variable
               labels to subsetted data frames that have been subsetted with \code{\link{subset}},
               \code{\link[dplyr]{select}} or \code{\link[dplyr]{filter}}.
               \cr \cr
               In case \code{df_origin} is \code{NULL}, all possible label attributes
               from \code{df_new} are removed.
}
\note{
In case \code{df_origin} is \code{NULL}, all possible label attributes
        from \code{df_new} are removed. \cr \cr
        dplyr >= 0.4.2 no longer drops vector attributes; you'll only need
        to set back labels when using dplyr up to 0.4.1.
}
\examples{
data(efc)
efc.sub <- subset(efc, subset = e16sex == 1, select = c(4:8))
str(efc.sub)

efc.sub <- add_labels(efc.sub, efc)
str(efc.sub)

efc.sub <- add_labels(efc.sub)
str(efc.sub)
}
\seealso{
\href{http://www.strengejacke.de/sjPlot/labelleddata/}{sjPlot-manual}
           on working with labelled data, and \code{\link{remove_labels}} for
           removing label attributes from data frames.
}

