% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/save_plot.R
\name{save_plot}
\alias{save_plot}
\title{Save ggplot-figure for print publication}
\usage{
save_plot(filename, fig = ggplot2::last_plot(), width = 12, height = 9,
  dpi = 300, theme = ggplot2::theme_get(), label.color = "black",
  label.size = 2.4, axis.textsize = 0.8, axis.titlesize = 0.75,
  legend.textsize = 0.6, legend.titlesize = 0.65, legend.itemsize = 0.5)
}
\arguments{
\item{filename}{Name of the output file; filename must end with one
of the following accepted file types: ".png", ".jpg", ".svg" or ".tif".}

\item{fig}{The plot that should be saved. By default, the last plot is saved.}

\item{width}{Width of the figure, in centimetres.}

\item{height}{Height of the figure, in centimetres.}

\item{dpi}{Resolution in dpi (dots per inch). Ignored for vector formats, such as ".svg".}

\item{theme}{The default theme to use when saving the plot.}

\item{label.color}{Color value for labels (axis, plot, etc.).}

\item{label.size}{Fontsize of value labels inside plot area.}

\item{axis.textsize}{Fontsize of axis labels.}

\item{axis.titlesize}{Fontsize of axis titles.}

\item{legend.textsize}{Fontsize of legend labels.}

\item{legend.titlesize}{Fontsize of legend title.}

\item{legend.itemsize}{Size of legend's item (legend key), in centimetres.}
}
\description{
Convenient function to save the last ggplot-figure in
               high quality for publication.
}
\note{
This is a convenient function with some default settings that should
        come close to most of the needs for fontsize and scaling in figures
        when saving them for printing or publishing. It uses cairographics
        anti-aliasing (see \code{\link[grDevices]{png}}).
        \cr \cr
        For adjusting plot appearance, see also \code{\link{sjPlot-themes}}.
}
