% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sjPlotKfoldCV.R
\name{sjp.kfold_cv}
\alias{sjp.kfold_cv}
\title{Plot model fit from k-fold cross-validation}
\usage{
sjp.kfold_cv(data, formula, k = 5, fit)
}
\arguments{
\item{data}{A data frame, used to split the data into \code{k} trainig-test-pairs.}

\item{formula}{A model formula, used to fit linear models (\code{\link[stats]{lm}})
over all \code{k} training data sets. Use \code{fit} to specify a 
fitted model (also other models than linear models), which will be used
to compute cross validation. If \code{fit} is not missing, \code{formula}
will be ignored.}

\item{k}{Number of folds.}

\item{fit}{Model object, which will be used to compute cross validation. If 
\code{fit} is not missing, \code{formula} will be ignored. Currently,
only linear, poisson and negative binomial regression models are supported.}
}
\description{
This function plots the aggregated residuals of k-fold cross-validated
               models against the outcome. This allows to evaluate how the model performs
               according over- or underestimation of the outcome.
}
\details{
This function, first, generates \code{k} cross-validated test-training
           pairs (using the \code{\link[modelr]{crossv_kfold}}-function) and
           fits the same model, specified in the \code{formula}- or \code{fit}-
           argument, over all training data sets. \cr \cr
           Then, the test data is used to predict the outcome from all
           models that have been fit on the training data, and the residuals
           from all test data is plotted against the observed values (outcome)
           from the test data (note: for poisson or negative binomial models, the
           deviance residuals are calculated). This plot can be used to validate the model
           and see, whether it over- (residuals > 0) or underestimates 
           (residuals < 0) the model's outcome.
}
\note{
Currently, only linear, poisson and negative binomial regression models are supported.
}
\examples{
library(sjmisc)
data(efc)

sjp.kfold_cv(efc, neg_c_7 ~ e42dep + c172code + c12hour)
sjp.kfold_cv(mtcars, mpg ~.)

# for poisson models. need to fit a model and use 'fit'-argument
fit <- glm(tot_sc_e ~ neg_c_7 + c172code, data = efc, family = poisson)
sjp.kfold_cv(efc, fit = fit)

# and for negative binomial models
fit <- MASS::glm.nb(tot_sc_e ~ neg_c_7 + c172code, data = efc)
sjp.kfold_cv(efc, fit = fit)

}
