% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LMS2z.R
\name{z2cent}
\alias{z2cent}
\title{Express z-scores as centile character strings for plotting}
\usage{
z2cent(z)
}
\arguments{
\item{z}{a scalar or vector of z-scores.}
}
\value{
A character string is returned, the same length as z. Z-scores between
the 1st and 99th centile are converted to centiles with one or two significant
figures (lower tail) or to their complement (upper tail). For larger z-scores
in absolute value the character consists of "SDS" appended to the z-score
rounded to one decimal place.
}
\description{
Converts z-scores, typically defining centiles in a growth chart, to
character strings that can be used to label the centile curves.
}
\examples{

z2cent(-4:4)
z2cent(qnorm(0:100/100))

}
\seealso{
\code{\link{cLMS}}
}
\author{
Tim Cole \email{tim.cole@ucl.ac.uk}
}
\keyword{character}
