\encoding{UTF-8}
\name{select}
\alias{select}
%- Also NEED an '\alias' for EACH other topic documented here.
\alias{size.sel}
\alias{powlinear.sel}
\title{
%%  ~~function to do ... ~~
Competitor Selection Rules
}
\description{
%%  ~~ A concise (1-5 lines) description of what the function does. ~~
Functions returning TRUE for plants that compete with a given subject plant, or FALSE otherwise. The decision can depend on distance and plant marks. For use in \code{\link{pairwise}}.
}
\usage{
size.sel(imarks, jmarks, dists, dranks, par = list(k = 0.2, smark = 1))

powlinear.sel(imarks, jmarks, dists, dranks, par = list(ki = 0.2, kj = 0,
  p = 1, r0 = 0, smark=1))
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{imarks}{
%%     ~~Describe \code{imarks} here~~
Marks for the subject plant, a 1-row data frame.}
  \item{jmarks}{
%%     ~~Describe \code{jmarks} here~~
Data frame with marks for potential competitors}
  \item{dists}{
%%     ~~Describe \code{dists} here~~
Vector of distances between the subject plant and the potential competitors.}
  \item{dranks}{
%%     ~~Describe \code{dranks} here~~
Distance ranks.}
  \item{par}{
%%     ~~Describe \code{par} here~~
List of parameters.}
}
\details{
%%  ~~ If necessary, more details than the description above ~~
The values of \code{par} must be given in the argument \code{selpar} of \code{pairwise}, they are shown here as examples.

\code{smark} in \code{par} indicates the location of the plant size variable in \code{marks}. It can be a data frame column number, or a string id like "dbh".

\code{size.sel} is a simple example where competitors are selected within a radius proportional to plant size. This corresponds to the second example in Section 9.2.1 of Burkhart and \enc{Tomé}{Tome} (2012).

Note that their first example (fixed radius) is implemented by giving a value to \code{maxR} in \code{\link{pairwise}}, no \code{select} function is needed. Similarly, their third example (fixed number of nearest neighbors) is obtained by giving a value to \code{maxN}.

\code{powlinear.sel} is a general form that covers all the other examples in Burkhart and \enc{Tomé}{Tome} (2012) with particular values for the parameters (except for the \emph{competition elimination angle}, which depends on relative positions among competitors):
\describe{
\item{ }{Multiple of crown radius: \code{kj=0, p=1, r0=0, smark="crownwidth"}.}
\item{ }{Angle count sampling: \code{ki=0, p=1, r0=0, smark="dbh"}.}
\item{ }{Areas of influence overlap: \code{ki=kj, p=1, r0=0}, if the radius is a linear function of size (\code{p} not 1 for an allometric relationship).}
\item{ }{Vertical search cone: \code{ki} = \eqn{- c_i / \tan(90 - \beta/2)}, \code{kj} = \eqn{1 / \tan(90 - \beta/2)}, \code{p=1, smark="height"}.}  
}
These and other examples could be coded directly if computational efficiency is important.
}
\value{
%%  ~Describe the value returned
%%  If it is a LIST, use
%%  \item{comp1 }{Description of 'comp1'}
%%  \item{comp2 }{Description of 'comp2'}
%% ...
Logical vector of length equal to the length of \code{dists}.
}
\references{
%% ~put references to the literature/web site here ~
\url{http://forestgrowth.unbc.ca/siplab}

Burkhart, H. E. and \enc{Tomé}{Tome}, M. (2012) \emph{Modeling Forest Trees and Stands}. Springer.
}
\author{
%%  ~~who you are~~
Oscar \enc{García}{Garcia}.
}
%\note{
%%  ~~further notes~~
%}

%% ~Make other sections like Warning with \section{Warning }{....} ~

\seealso{
%% ~~objects to See Also as \code{\link{help}}, ~~~
\code{\link{pairwise}}
}
%\examples{
%}
% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
%\keyword{ ~kwd1 }
%\keyword{ ~kwd2 }% __ONLY ONE__ keyword per line
