% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/control.R
\name{controlPopVar}
\alias{controlPopVar}
\title{Control parameters for population size estimation}
\usage{
controlPopVar(
  alpha = 0.05,
  bootType = c("parametric", "semiparametric", "nonparametric"),
  B = 500,
  confType = c("percentilic", "normal", "basic"),
  keepbootStat = TRUE,
  traceBootstrapSize = FALSE,
  bootstrapVisualTrace = FALSE,
  fittingMethod = c("optim", "IRLS"),
  bootstrapFitcontrol = NULL,
  sd = c("sqrtVar", "normalMVUE"),
  covType = c("observedInform", "Fisher"),
  cores = 1L
)
}
\arguments{
\item{alpha}{significance level, 0.05 used by default.}

\item{bootType}{bootstrap type. Default is \code{"parametric"},
other possible values are: \code{"semiparametric"} and \code{"nonparametric"}.}

\item{B}{number of bootstrap samples to be performed (default 500).}

\item{confType}{type of confidence interval for bootstrap confidence interval,
\code{"percentile"} by default.
Other possibilities: \code{"studentized"} and \code{"basic"}.}

\item{keepbootStat}{boolean value indicating whether to keep a vector of
statistics produced by bootstrap.}

\item{traceBootstrapSize}{boolean value indicating whether to print size of
bootstrapped sample after truncation for semi- and fully parametric bootstraps.}

\item{bootstrapVisualTrace}{boolean value indicating whether to plot bootstrap
statistics in real time if \code{cores = 1} if \code{cores > 1} it instead
indicates whether to make progress bar.}

\item{fittingMethod}{method used for fitting models from bootstrap samples.}

\item{bootstrapFitcontrol}{control parameters for each regression works exactly
like \code{controlMethod} but for fitting models from bootstrap samples.}

\item{sd}{indicates how to compute standard deviation of population
size estimator either as:
\mjsdeqn{\hat{\sigma}=\sqrt{\hat{\text{var}}(\hat{N})}}
for \code{sqrt} (which is slightly biased if \mjseqn{\hat{N}}
has a normal distribution) or for \code{normalMVUE} as the unbiased
minimal variance estimator for normal distribution:
\mjsdeqn{\hat{\sigma}=\sqrt{\hat{\text{var}}(\hat{N})}
\frac{\Gamma\left(\frac{N_{obs}-1}{2}\right)}{\Gamma\left(\frac{N_{obs}}{2}\right)}
\sqrt{\frac{N_{obs}}{2}}}
where the ration involving gamma functions is computed by log gamma function.}

\item{covType}{type of covariance matrix for regression parameters by default
observed information matrix.}

\item{cores}{for bootstrap only, number of processor cores to be used,
any number greater than 1 activates code designed with \code{doParallel},
\code{foreach} and \code{parallel} packages. Note that for now using parallel
computing makes tracing impossible so \code{traceBootstrapSize} and
\code{bootstrapVisualTrace} parameters are ignored in this case.}
}
\value{
A list with selected parameters, it is also possible to call list directly.
}
\description{
Creating control parameters for population size estimation and
respective standard error and variance estimation.
}
\seealso{
\code{\link[=estimatePopsize]{estimatePopsize()}} \code{\link[=controlModel]{controlModel()}} \code{\link[=controlMethod]{controlMethod()}}
}
\author{
Piotr Chlebicki, Maciej Beręsewicz
\loadmathjax
}
