% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/haystack_visualization.R
\name{plot_gene_haystack_raw}
\alias{plot_gene_haystack_raw}
\title{Visualizing the detection/expression of a gene in a 2D plot}
\usage{
plot_gene_haystack_raw(
  x,
  y,
  gene,
  expression,
  detection = NULL,
  high.resolution = FALSE,
  point.size = 1,
  order.by.signal = FALSE
)
}
\arguments{
\item{x}{x-axis coordinates of cells in a 2D representation (e.g. resulting from PCA or t-SNE)}

\item{y}{y-axis coordinates of cells in a 2D representation}

\item{gene}{name of a gene that is present in the input expression data, or a numerical index}

\item{expression}{a logical/numerical matrix showing detection/expression of genes (rows) in cells (columns)}

\item{detection}{an optional logical matrix showing detection of genes (rows) in cells (columns). If left as NULL, the density distribution of the gene is not plotted.}

\item{high.resolution}{logical (default: FALSE). If set to TRUE, the density plot will be of a higher resolution}

\item{point.size}{numerical value to set size of points in plot. Default is 1.}

\item{order.by.signal}{If TRUE, cells with higher signal will be put on the foreground in the plot. Default is FALSE.}
}
\value{
A plot
}
\description{
Visualizing the detection/expression of a gene in a 2D plot
}
\examples{
# using the toy example of the singleCellHaystack package
# define a logical matrix with detection of each gene (rows) in each cell (columns)
dat.detection <- dat.expression > 1
# various was of plotting gene expression patterns
plot_gene_haystack(dat.tsne, expression=dat.expression, gene="gene_242",
 detection = dat.detection, high.resolution = TRUE)
plot_gene_haystack(dat.tsne, expression=dat.expression, gene="gene_242",
 detection = dat.detection, high.resolution = TRUE, point.size = .1)
}
