\name{plot.simule}
\alias{plot.simule}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{
  Plotting functions for displaying the list of multiple graphs generated by the simule algorithm
}
\description{
This function plots either the shared graph, the task-specific networks, the networks or the neighborhood networks for a certain node. Please run demo(simuleDemo) to learn the basic functions provided by this package.  For further details, please read the original paper:  <http://link.springer.com/article/10.1007/s10994-017-5635-7>.
}
\usage{
  \method{plot}{simule}(x, type="graph", subID=NULL, index=NULL, ...)
}
\arguments{
  \item{x}{
    simule object
  }
  \item{type}{
    Plotting type. This argument defines which type of network(s) to plot. There are four options:
    "graph": plot the networks. The different colors represent the different graphs.

    "share": plot the shared graph.

    "sub": plot subject-specific networks.

    "neighbor": plot the neighborhood networks for a given node. The different colors represent the different graphs.
  }
  \item{subID}{
    If \code{type="sub"}, \code{subID} indicates to plot the task-specific network for the task whose index == subID.
  }
  \item{index}{
    If \code{type="neighbor"}, \code{index} indicates the row number of the node to be investigated. This function plots its neighborhood networks in each graph of the multiple graphs generated by simule algorithm.
  }
  \item{...}{
    Additional arguments to pass to plot function
  }
}
\details{
  Plotting function for simule objects. It can be used to plot results obtained from running the simule algorithm.
}
\references{
Beilun Wang, Ritambhara Singh, Yanjun Qi (2017).  A constrained L1 minimization approach for estimating multiple Sparse Gaussian or Nonparanormal Graphical Models. http://link.springer.com/article/10.1007/s10994-017-5635-7
}
\author{
  Beilun Wang and Yanjun Qi
}
\seealso{
  \code{\link{simule}}
}
\examples{
  \dontrun{
    data(exampleData)
    results = simule(X = exampleData , 0.05, 1, covType = "cov", TRUE)
    plot.simule(results)
    plot.simule(results, type="share")
    plot.simule(results, type="sub", subID=1)
    plot.simule(results, type="neighbor", index=50)
  }
}
\keyword{ simule }
