% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utility.R
\name{updateDef}
\alias{updateDef}
\title{Update definition table}
\usage{
updateDef(
  dtDefs,
  changevar,
  newformula = NULL,
  newvariance = NULL,
  newdist = NULL,
  newlink = NULL,
  remove = FALSE
)
}
\arguments{
\item{dtDefs}{Definition table that will be modified}

\item{changevar}{Name of field definition that will be changed}

\item{newformula}{New formula definition (defaults to NULL)}

\item{newvariance}{New variance specification (defaults to NULL)}

\item{newdist}{New distribution definition (defaults to NULL)}

\item{newlink}{New link specification (defaults to NULL)}

\item{remove}{If set to TRUE, remove `changevar`from
definition (defaults to FALSE).}
}
\value{
The updated data definition table.
}
\description{
Updates row definition table created by function
defData or defRead. (For tables created using defDataAdd
and defReadAdd use updateDefAdd.) Does not modify in-place.
}
\examples{

# Example 1

defs <- defData(varname = "x", formula = 0, variance = 3, dist = "normal")
defs <- defData(defs, varname = "y", formula = "2 + 3*x", variance = 1, dist = "normal")
defs <- defData(defs, varname = "z", formula = "4 + 3*x - 2*y", variance = 1, dist = "normal")

defs

updateDef(dtDefs = defs, changevar = "y", newformula = "x + 5", newvariance = 2)
updateDef(dtDefs = defs, changevar = "z", newdist = "poisson", newlink = "log")

# Example 2

defs <- defData(varname = "w", formula = 0, variance = 3, dist = "normal")
defs <- defData(defs, varname = "x", formula = "1 + w", variance = 1, dist = "normal")
defs <- defData(defs, varname = "z", formula = 4, variance = 1, dist = "normal")

defs

updateDef(dtDefs = defs, changevar = "x", remove = TRUE)
updateDef(dtDefs = defs, changevar = "z", remove = TRUE)

# No changes to original definition:
defs
}
\concept{define_data}
\concept{utility}
