% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mergeData.R
\name{mergeData}
\alias{mergeData}
\title{Merge two data tables}
\usage{
mergeData(dt1, dt2, idvars)
}
\arguments{
\item{dt1}{Name of first data.table}

\item{dt2}{Name of second data.table}

\item{idvars}{Vector of string names to merge on}
}
\value{
A new data table that merges dt2 with dt1
}
\description{
Merge two data tables
}
\examples{
def1 <- defData(varname="x", formula = 0, variance = 1)
def1 <- defData(varname="xcat", formula = ".3;.2", dist = "categorical")

def2 <- defData(varname="yBin", formula = 0.5, dist = "binary", id="xcat")
def2 <- defData(def2, varname="yNorm", formula = 5, variance = 2)

dt1 <- genData(20, def1)
dt2 <- genData(3, def2)

dtMerge <- mergeData(dt1, dt2, "xcat")
dtMerge
}
