% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/genCorGen.R
\name{genCorGen}
\alias{genCorGen}
\title{Create multivariate (correlated) data - for general distributions}
\usage{
genCorGen(n, nvars, params1, params2 = NULL, dist, rho, corstr,
  corMatrix = NULL, wide = FALSE, cnames = NULL)
}
\arguments{
\item{n}{Number of observations}

\item{nvars}{Number of variables}

\item{params1}{A single vector specifying the mean of the distribution. The vector is of
length 1 if the mean is the same across all observations, otherwise the vector is of length
nvars. In the case of the uniform distribution the vector specifies the minimum.}

\item{params2}{A single vector specifying a possible second parameter for the distribution.
For the normal distribution, this will be the variance; for the gamma distribution, this
will be the dispersion; and for the uniform distribution, this will be the maximum. The
vector is of length 1 if the mean is the same across all observations, otherwise the vector
is of length nvars.}

\item{dist}{A string indicating "binary", "poisson" or "gamma", "normal", or "uniform".}

\item{rho}{Correlation coefficient, -1 <= rho <= 1. Use if corMatrix is not provided.}

\item{corstr}{Correlation structure of the variance-covariance matrix
defined by sigma and rho. Options include "cs" for a compound symmetry structure
and "ar1" for an autoregressive structure.}

\item{corMatrix}{Correlation matrix can be entered directly. It must be symmetrical and
positive semi-definite. It is not a required field; if a matrix is not provided, then a
structure and correlation coefficient rho must be specified.}

\item{wide}{The layout of the returned file - if wide = TRUE, all new correlated
variables will be returned in a single record, if wide = FALSE, each new variable
will be its own record (i.e. the data will be in long form). Defaults to FALSE.}

\item{cnames}{Explicit column names. A single string with names separated
by commas. If no string is provided, the default names will be V#, where #
represents the column.}
}
\value{
data.table with added column(s) of correlated data
}
\description{
Create multivariate (correlated) data - for general distributions
}
\examples{
l <- c(8, 10, 12)

genCorGen(1000, nvars = 3, params1 = l, dist = "poisson", rho = .7, corstr = "cs")
genCorGen(1000, nvars = 3, params1 = 5, dist = "poisson", rho = .7, corstr = "cs")
genCorGen(1000, nvars = 3, params1 = l, dist = "poisson", rho = .7, corstr = "cs", wide = TRUE)
genCorGen(1000, nvars = 3, params1 = 5, dist = "poisson", rho = .7, corstr = "cs", wide = TRUE)

genCorGen(1000, nvars = 3, params1 = l, dist = "poisson", rho = .7, corstr = "cs",
          cnames = "new_var")
genCorGen(1000, nvars = 3, params1 = l, dist = "poisson", rho = .7, corstr = "cs",
          wide = TRUE, cnames = "a, b, c")

genCorGen(1000, nvars = 3, params1 = c(.3, .5, .7), dist = "binary", rho = .3, corstr = "cs")
genCorGen(1000, nvars = 3, params1 = l, params2 = c(1,1,1), dist = "gamma", rho = .3,
          corstr = "cs", wide = TRUE)

}
