% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/genNthEvent.R
\name{genNthEvent}
\alias{genNthEvent}
\title{Generate event data using longitudinal data, and restrict output to time
until the nth event.}
\usage{
genNthEvent(dtName, defEvent, nEvents = 1, perName = "period",
  id = "id")
}
\arguments{
\item{dtName}{name of existing data table}

\item{defEvent}{data definition table (created with defDataAdd) that
determines the event generating process.}

\item{nEvents}{maximum number of events that will be generated (the nth
event).}

\item{perName}{variable name for period field. Defaults to "period"}

\item{id}{string representing name of the id 
field in table specified by dtName}
}
\value{
data.table that stops after "nEvents" are reached.
}
\description{
Generate event data using longitudinal data, and restrict output to time
until the nth event.
}
\examples{
defD <- defData(varname = "effect", formula = 0, variance = 1, 
                dist = "normal")
defE <- defDataAdd(varname = "died", formula = "-2.5 + 0.3*period + effect", 
                   dist = "binary", link = "logit")

d <- genData(1000, defD)
d <- addPeriods(d, 10)
dx <- genNthEvent(d, defEvent = defE, nEvents = 3)
}
