% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SimplaceWrapper.R
\name{stepAllSimulations}
\alias{stepAllSimulations}
\title{Run all simulations in queue stepwise}
\usage{
stepAllSimulations(simplace, count = 1, filter = NULL, parameterLists = NULL)
}
\arguments{
\item{simplace}{handle to the SimplaceWrapper object returned by \code{\link{initSimplace}}}

\item{count}{number of steps to be performed}

\item{filter}{vector of the variable names to be included in the result. If not set, all variables are returned}

\item{parameterLists}{a list of parameter lists for each simulation}
}
\value{
handle to an array of data containers which has to be processed afterwards
}
\description{
Performs \code{count} steps of the simulation and returns the values from 
the actual variable map. Can be called consecutively.
}
\examples{
\dontrun{
simplace <- initSimplace(SimplaceInstallationDir,SimplaceWorkDir,SimplaceOutputDir)
openProject(simplace, Solution)
createSimulation(simplace)
vm <- stepAllSimulations(simplace,count=22)
vm_s <- stepAllSimulations(simplace,filter=c("CURRENT.DATE","LintulBiomass.sWSO"),count=18)
closeProject(simplace)   }

}
