% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SimplaceWrapper.R
\docType{package}
\name{simplace}
\alias{simplace}
\alias{simplace-package}
\title{simplace: Interface to use the modelling framework 'SIMPLACE'}
\description{
Interface to interact with the modelling framework 'SIMPLACE' and to
parse the results of simulations
}
\details{
Package needs a Java Runtime Environment as well as an installation of 'SIMPLACE'. 
See \href{https://www.simplace.net/}{www.simplace.net} for more information about 'SIMPLACE'.
}
\examples{
  \dontrun{
    SimplaceInstallationDir <- "D:/java/simplace/"
    
    SimplaceWorkDir <- "D:/java/simplace/simplace_run/simulation/"
    SimplaceOutputDir <-  "D:/java/simplace/simplace_run/output/"
    
    Solution <- "D:/java/simplace/simplace_run/simulation/gk/solution/complete/Complete.sol.xml"
    
    simplace <- initSimplace(SimplaceInstallationDir,SimplaceWorkDir,SimplaceOutputDir)
    
    openProject(simplace, Solution)
    
    parameter <- list()
    parameter$vTempLimit <- 32
    
    simid <- createSimulation(simplace,parameter)
    runSimulations(simplace)
    
    result <- getResult(simplace,"DIAGRAM_OUT", simid);
    
    closeProject(simplace)
    
    resultlist <- resultToList(result)
    resultframe <- resultToDataframe(result)
  }

}
\references{
\href{https://www.simplace.net/}{www.simplace.net}
}
\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/gk-crop/simplace_rpkg/}
  \item \url{https://r-forge.r-project.org/projects/simplace/}
}

}
\author{
{Gunther Krauss}
}
