% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.simmr_output.R
\name{plot.simmr_output}
\alias{plot.simmr_output}
\title{Plot different features of an object created from \code{\link{simmr_mcmc}}
or \code{\link{simmr_ffvb}}.}
\usage{
\method{plot}{simmr_output}(
  x,
  type = c("isospace", "histogram", "density", "matrix", "boxplot"),
  group = 1,
  binwidth = 0.05,
  alpha = 0.5,
  title = if (length(group) == 1) {
     "simmr output plot"
 } else {
    
    paste("simmr output plot: group", group)
 },
  ggargs = NULL,
  ...
)
}
\arguments{
\item{x}{An object of class \code{simmr_output} created via
\code{\link{simmr_mcmc}} or \code{\link{simmr_ffvb}}.}

\item{type}{The type of plot required. Can be one or more of 'histogram',
'density', 'matrix', or 'boxplot'}

\item{group}{Which group(s) to plot.}

\item{binwidth}{The width of the bins for the histogram. Defaults to 0.05}

\item{alpha}{The degree of transparency of the plots. Not relevant for
matrix plots}

\item{title}{The title of the plot.}

\item{ggargs}{Extra arguments to be included in the ggplot (e.g. axis limits)}

\item{...}{Currently not used}
}
\description{
This function allows for 4 different types of plots of the simmr output
created from \code{\link{simmr_mcmc}} or \code{\link{simmr_ffvb}}. The
types are: histogram, kernel density plot, matrix plot (most useful) and
boxplot. There are some minor customisation options.
}
\details{
The matrix plot should form a necessary part of any SIMM analysis since it
allows the user to judge which sources are identifiable by the model.
Further detail about these plots is provided in the vignette.
Some code from
https://stackoverflow.com/questions/14711550/is-there-a-way-to-change-the-color-palette-for-ggallyggpairs-using-ggplot
accessed March 2023
}
\examples{
\dontrun{
# A simple example with 10 observations, 2 tracers and 4 sources

# The data
data(geese_data)

# Load into simmr
# Plot
plot(simmr_1)


# MCMC run
simmr_1_out <- simmr_mcmc(simmr_1)

# Plot
plot(simmr_1_out) # Creates all 4 plots
plot(simmr_1_out, type = "boxplot")
plot(simmr_1_out, type = "histogram")
plot(simmr_1_out, type = "density")
plot(simmr_1_out, type = "matrix")
}
}
\seealso{
See \code{\link{simmr_mcmc}} and \code{\link{simmr_ffvb}} for
creating objects suitable for this function, and many more examples. See
also \code{\link{simmr_load}} for creating simmr objects,
\code{\link{plot.simmr_input}} for creating isospace plots,
\code{\link{summary.simmr_output}} for summarising output.
}
\author{
Andrew Parnell <andrew.parnell@mu.ie>, Emma Govan
}
