% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simml.main.R
\name{ordinal.data}
\alias{ordinal.data}
\title{A function for ordinal categorical response data generation.}
\usage{
ordinal.data(n = 400, p = 10, R = 11, delta = 1, s = "nonlinear")
}
\arguments{
\item{n}{sample size.}

\item{p}{dimension of covariates.}

\item{R}{number of response levels in y}

\item{delta}{magnitude of "main" effect (i.e., "nuisance" effect) of the covariates; a large delta means a larger "nuisance" variance.}

\item{s}{type of the treatment-by-covariates interation effect ("linear" or "nonlinear")}
}
\value{
\item{y}{a n-by-1 vector of treatment outcomes.}
\item{A}{a n-by-1 vector of treatment indicators.}
\item{X}{a n-by-p matrix of pretreatment covariates.}
\item{SNR}{the "signal" (interaction effect) to "nuisance" (main effect) variance ratio (SNR) in the canonical parameter function.}
\item{true.beta}{the true single-index coefficient vector.}
\item{delta}{magnitude of "main" effect.}
\item{s}{type of the treatment-by-covariates interation effect.}
}
\description{
\code{ordinal.data} generates ordered category response data (with p covariates and a treatment variable).
}
