% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trajectory-methods.R
\name{Extract.trajectory}
\alias{Extract.trajectory}
\alias{[.trajectory}
\alias{[[.trajectory}
\alias{[<-.trajectory}
\alias{[[<-.trajectory}
\title{Extract or Replace Parts of a Trajectory}
\usage{
\method{[}{trajectory}(x, i)

\method{[[}{trajectory}(x, i)

\method{[}{trajectory}(x, i) <- value

\method{[[}{trajectory}(x, i) <- value
}
\arguments{
\item{x}{the trajectory object.}

\item{i}{indices specifying elements to extract. Indices are \code{numeric}
or \code{character} or \code{logical} vectors or empty (missing) or \code{NULL}.

Numeric values are coerced to integer as by \code{\link{as.integer}} (and
hence truncated towards zero). Negative integers indicate elements/slices to
leave out the selection.

Character vectors will be matched to the names of the activities in the
trajectory as by \code{\link{\%in\%}}.

Logical vectors indicate elements/slices to select. Such vectors are recycled
if necessary to match the corresponding extent.

An empty index will return the whole trajectory.

An index value of \code{NULL} is treated as if it were \code{integer(0)}.}

\item{value}{another trajectory object.}
}
\value{
Returns a new trajectory object.
}
\description{
Operators acting on trajectories to extract or replace parts.
}
\examples{
x <- join(lapply(1:12, function(i)
  trajectory() \%>\% timeout(i)
))
x

x[10]                 # the tenth element of x
x[-1]                 # delete the 1st element of x
x[c(TRUE, FALSE)]     # logical indexing
x[c(1, 5, 2, 12, 4)]  # numeric indexing
x[c(FALSE, TRUE)] <- x[c(TRUE, FALSE)] # replacing
x

}
\seealso{
\code{\link{length.trajectory}}, \code{\link{get_n_activities}},
\code{\link{join}}.
}
