% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sfa_get_statement.R
\name{sfa_get_statement}
\alias{sfa_get_statement}
\title{Get basic company information}
\usage{
sfa_get_statement(
  ticker = NULL,
  simfin_id = NULL,
  statement,
  period = "fy",
  fyear = NULL,
  start = NULL,
  end = NULL,
  ttm = FALSE,
  shares = FALSE,
  api_key = getOption("sfa_api_key"),
  cache_dir = getOption("sfa_cache_dir"),
  sfplus = getOption("sfa_sfplus", default = FALSE)
)
}
\arguments{
\item{ticker}{\link{integer} Ticker of the companies of interest.}

\item{simfin_id}{\link{integer} 'SimFin' IDs of the companies of interest. Any
\code{simfin_id} will be internally translated to the respective \code{ticker}. This
reduces the number of queries in case you query the same company via
\code{ticker} \emph{and} \code{simfin_id}.}

\item{statement}{\link{character} Statement to be retrieved. One of
\itemize{
\item \code{"pl"}: Profit & Loss statement
\item \code{"bs"}: Balance Sheet
\item \code{"cf"}: Cash Flow statement
\item \code{"derived"}: Derived figures & fundamental ratios
\item \code{"all"}: Retrieves all 3 statements + ratios. Please note that this
option is reserved for SimFin+ users.
}}

\item{period}{\link{character} Filter for periods. As a non-SimFin+ user, you have
to provide exactly one period. As SimFin+ user, this filter can be omitted
to retrieve all statements available for the company.
\itemize{
\item \code{"q1"}: First fiscal quarter.
\item \code{"q2"}: Second fiscal quarter.
\item \code{"q3"}: Third fiscal quarter.
\item \code{"q4"}: Fourth fiscal quarter.
\item \code{"fy"}: Full fiscal year.
\item \code{"h1"}: First 6 months of fiscal year.
\item \code{"h2"}: Last 6 months of fiscal year.
\item \code{"9m"}: First nine months of fiscal year.
\item \code{"6m"}: Any fiscal 6 month period (first + second half years; reserved
for SimFin+ users).
\item \code{"quarters"}: All quarters (q1 + q2 + q3 + q4; reserved for SimFin+
users).
}}

\item{fyear}{\link{integer} Filter for fiscal year. As a non-SimFin+ user, you
have to provide exactly one fiscal year. As SimFin+ user, this filter can
be omitted to retrieve all data available for the company.}

\item{start}{\link{Date} Filter for the report dates (reserved for SimFin+ users).
With this filter you can filter the statements by the date on which the
reported period ended ('Report Date'). By specifying a value here, only
statements will be retrieved with report dates ending AFTER the specified
date.}

\item{end}{\link{Date} Filter for the report dates (reserved for SimFin+ users).
With this filter you can filter the statements by the date on which the
reported period ended ('Report Date'). By specifying a value here, only
statements will be retrieved with report dates ending BEFORE the specified
date.}

\item{ttm}{\link{logical} If \code{TRUE}, you can return the trailing twelve months
statements for all periods, meaning at every available point in time the
sum of the last 4 available quarterly figures.}

\item{shares}{\link{logical} If \code{TRUE}, you can display the weighted average basic
& diluted shares outstanding for each period along with the fundamentals.
Reserved for SimFin+ users (as non-SimFin+ user, you can still use the
shares outstanding endpoints).}

\item{api_key}{\link{character} Your 'SimFin' API key. It's recommended to set
the API key globally using \link{sfa_set_api_key}.}

\item{cache_dir}{\link{character} Your cache directory. It's recommended to set
the cache directory globally using \link{sfa_set_cache_dir}.}

\item{sfplus}{\link{logical} Set\code{TRUE} if you have a SimFin+ account. It's
recommended to set \code{sfplus} globally using \link{sfa_set_sfplus}.}
}
\value{
\link{data.table} containing the statement(s) data.
}
\description{
Fundamentals and derived figures can be retrieved here.
}
\section{Parallel processing}{

This function supports parallel processing via \code{future.apply}. If your
machine has several cores (most have), you can make the API calls in
parallel. To do so, define a \code{future::plan()} before calling the function.
}

