% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mc.matrix.R
\name{mc.matrix}
\alias{mc.matrix}
\alias{build.mc.matrix}
\alias{check.mc.matrix}
\title{Build and check misclassification matrices from empirical estimations}
\usage{
build.mc.matrix(mc.matrix, method = "series",
  tuning = sqrt(.Machine$double.eps), diag.cor = FALSE,
  tol = .Machine$double.eps, max.iter = 100)
}
\arguments{
\item{mc.matrix}{an empirical misclassification matrix}

\item{method}{method used to estimate the generator for the misclassification matrix. One of "series", "log" or "jlt" (see Details)}

\item{tuning}{security parameter for numerical reasons}

\item{diag.cor}{should corrections be substracted from the diagonal or from all values corresponding to the size?}

\item{tol}{tolerance level for series method for convegence}

\item{max.iter}{maximal number of iterations for the series method to converge.
Ignored if method is not "series"}
}
\value{
\code{build.mc.matrix()} returns a misclassification matrix that is the closest estimate for a working misclassification matrix.

\code{check.mc.matrix()} returns a vector of logicals.
}
\description{
Empirical misclassification matrices to the power of lambda may not exist for
small values of lambda. These functions provide methods to estimate the nearest
version of the misclassification matrix that satisfies the conditions a
misclassification matrix has to fulfill, and to check it (existance for exponents
smaller than 1).
}
\details{
Method "series" constructs a generator via the series

\eqn{(Pi-I) - (Pi-I)^2/2 + (Pi-I)^3/3 - \dots}

Method "log" constructs the generator via taking the log of the misclassification matrix. Small negative off-diagonal values are corrected and set to (0 + tuning).
The amount used to correct for negative values is added to the diagonal element if \code{diag.cor = TRUE} and distributed among all values if \code{diag.cor = FALSE}.

Method "jlt" uses the method described by Jarrow et al. (see Israel et al.).
}
\examples{
Pi <- matrix(data = c(0.989, 0.01, 0.001, 0.17, 0.829, 0.001, 0.001, 0.18, 0.819),
nrow = 3, byrow = FALSE)
check.mc.matrix(list(Pi))
check.mc.matrix(list(build.mc.matrix(Pi)))
build.mc.matrix(Pi)

Pi3 <- matrix(c(0.8, 0.2, 0, 0, 0, 0.8, 0.1, 0.1, 0, 0.1, 0.8, 0.1, 0, 0, 0.3, 0.7), nrow = 4)
check.mc.matrix(list(Pi3))
build.mc.matrix(Pi3)
check.mc.matrix(list(build.mc.matrix(Pi3)))
P1 <- matrix(c(1, 0, 0, 1), nrow = 2)
P2 <- matrix(c(0.8, 0.15, 0, 0.2, 0.7, 0.2, 0, 0.15, 0.8), nrow = 3, byrow = TRUE)
P3 <- matrix(c(0.4, 0.6, 0.6, 0.4), nrow = 2)
mc.matrix <- list(P1, P2, P3)
check.mc.matrix(mc.matrix) # TRUE FALSE FALSE

}
\references{
Israel, R.B., Rosenthal, J.S., Wei, J.Z., Finding generators for Markov Chains via empirical transition matrices, with applications to credit ratings,\emph{Mathematical Finance}, \bold{11}, 245--265
}
\seealso{
\code{\link[simex]{mcsimex}}, \code{\link[simex]{misclass}}, \code{\link[simex]{diag.block}}
}
\author{
Wolfgang Lederer, \email{wolfgang.lederer@gmail.com}
}
