% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simer.Data.R
\name{simer.Data}
\alias{simer.Data}
\title{Data handling}
\usage{
simer.Data(jsonList = NULL, out = "simer.qc", ncpus = 0, verbose = TRUE)
}
\arguments{
\item{jsonList}{a list of data quality control parameters.}

\item{out}{the prefix of output files.}

\item{ncpus}{the number of threads used, if NULL, (logical core number - 1) is automatically used.}

\item{verbose}{whether to print detail.}
}
\value{
the function returns a list containing
\describe{
\item{$genotype}{the path of genotype data.}
\item{$pedigree}{the filename of pedigree data.}
\item{$selection_index}{the selection index for all traits.}
\item{$breeding_value_index}{the breeding value index for all traits.}
\item{$quality_control_plan}{a list of parameters for data quality control.}
\item{$breeding_plan}{a list of parameters for genetic evaluation.}
}
}
\description{
Make data quality control for genotype, phenotype, and pedigree.
}
\details{
Build date: May 26, 2021
Last update: Apr 28, 2022
}
\examples{
# Read JSON file
jsonFile <- system.file("extdata", "04breeding_plan", "plan1.json", package = "simer")
jsonList <- jsonlite::fromJSON(txt = jsonFile, simplifyVector = FALSE)

\dontrun{
# It needs 'plink' and 'hiblup' software
jsonList <- simer.Data(jsonList = jsonList)
}
}
\author{
Dong Yin
}
