% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{ipu_step}
\alias{ipu_step}
\alias{combine_factors}
\alias{ipu_step}
\alias{ipu_step_ref}
\alias{ipu_step}
\alias{ipu_step_f}
\title{Perform one step of iterative proportional updating}
\usage{
combine_factors(dat, factor_columns, asfactor = TRUE)

ipu_step_ref(w, classes, targets)

ipu_step(w, classes, targets)

ipu_step_f(w, classes, targets)
}
\arguments{
\item{dat}{a data.frame containing the factor variables to be combined.}

\item{factor_columns}{a \code{character} vector containing the column names in \code{dat} to be combined. All columns must
be factors.}

\item{asfactor}{Wheter to return an integer or a factor variable.}

\item{w}{An numeric vector of weights. All entries should be positive.}

\item{classes}{A factor variable. Must have the same length as \code{w}.}

\item{targets}{key figure to target with the ipu scheme. A numeric verctor of the same length as \code{levels(classes)}.
This can also be a \code{table} produced by \code{xtabs}. See examples.}
}
\description{
C++ routines to invoke a single iteration of the Iterative proportional updating (IPU) scheme. Targets and classes
are assumed to be one dimensional in the \code{ipu_step} functions. \code{combine_factors} aggregates several vectors of
type factor into a single one to allow multidimensional ipu-steps. See examples.
}
\details{
\code{ipu_step} returns the adjusted weights. \code{ipu_step_ref} does the same, but updates \code{w} by reference rather than
returning. \code{ipu_step_f} returns a multiplicator: adjusted weights divided by unadjusted weights. \code{combine_factors} is
designed to make \code{ipu_step} work with contingency tables produced by \link{xtabs}.
}
\examples{

############# one-dimensional ipu ##############

## create random data
nobs <- 10
classLabels <- letters[1:3]
dat = data.frame(
  weight = exp(rnorm(nobs)),
  household = factor(sample(classLabels, nobs, replace = TRUE))
)
dat

## create targets (same lenght as classLabels!)
targets <- 3:5

## calculate weights
new_weight <- ipu_step(dat$weight, dat$household, targets)
cbind(dat, new_weight)

## check solution
xtabs(new_weight ~ dat$household)

## calculate weights "by reference"
ipu_step_ref(dat$weight, dat$household, targets)
dat

############# multidimensional ipu ##############

## load data
factors <- c("time", "sex", "smoker", "day")
data(tips, package = "reshape2")
tips <- tips[factors]

## combine factors
cf <- combine_factors(tips, names(tips))
cbind(tips, cf)[sample(nrow(tips), 10),]

## adjust weights
con <- xtabs(~., tips)
weight <- rnorm(nrow(tips)) + 5
adjusted_weight <- ipu_step(weight, cf, con)

## check outputs
con2 <- xtabs(adjusted_weight ~ ., data = tips)
sum((con - con2)^2)

}
