% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main_function.R
\name{fitSgraph}
\alias{fitSgraph}
\title{Estimate covariance matrix of a graphical model}
\usage{
fitSgraph(graph, S)
}
\arguments{
\item{graph}{A directed or undirected graph represented as a graphNEL object.}

\item{S}{A sample covariance matrix}
}
\value{
A covariance matrix with the independence constraints entailed by the graph.
}
\description{
Fit a Gaussian Graphical Model or a Gaussian Bayesian Network  by maximum likelihood.
}
\details{
If graph is undirected it uses the Iterative Proprotional Fitting algoritm (\pkg{qpgraph} package). If graph is directed it uses Iterative Conditional Fitting (\pkg{ggm} package).
}
\references{
Drton, M. & Richardson, T. S. (2003). A new algorithm for maximum likelihood estimation in Gaussian graphical models for marginal independence. Proceedings of the Ninetheen Conference on Uncertainty in Artificial Intelligence, 184-191.

Whittaker, J. Graphical models in applied multivariate statistics. Wiley, 1990.
}
\seealso{
\code{\link[ggm]{icfmag}},  \code{\link[qpgraph]{qpIPF}}
}

