% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simLife.R
\name{simFerrit}
\alias{simFerrit}
\title{Simulate a second phase}
\usage{
simFerrit(param, lam, box, mu = c(0, 1, 0), verbose = FALSE)
}
\arguments{
\item{param}{simulation parameter list}

\item{lam}{the intensity parameter of the underlying Poisson point process}

\item{box}{the simulation box}

\item{mu}{reference direction of particles, here \code{mu=c(0,1,0)} (default)}

\item{verbose}{logical, ignored}
}
\value{
list of spheroids
}
\description{
Poisson spheroid system
}
\details{
The function generates a system of constant size Poisson spheroidal objects with intensity \code{lam} and random planar 
orientation distribution. The spheroidal objects are labeled by \eqn{F} to denote the secondary 
particle phase, denoting for instance some disturbing ferrit inclusions in real life specimen.
}
\seealso{
\code{\link[unfoldr]{simSpheroidSystem}}
}

