% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/times.R
\name{getCrackTime}
\alias{getCrackTime}
\title{Generate individual fracture time}
\usage{
getCrackTime(theta, a, b, stress, vickers, param)
}
\arguments{
\item{theta}{colatitude angle}

\item{a}{axis length (axis orthogonal to rotational axis)}

\item{b}{rotational axis length}

\item{stress}{stress level}

\item{vickers}{Vickers hardness}

\item{param}{simulation parameter set}
}
\value{
numeric, the individual fracture time
}
\description{
Generate individual defect time for particle fracture
}
\details{
The particle fracture (crack) is assumed to happen orthogonal to the major axis direction along 
the maximum minor axis length. Thus the projection area can be easily computed for the purpose
of defect accumulation. The parameter set is made up of six parameters. Here only the second and 
third parameters are used to simulate the defect \code{crack} times. The failure times follow a 
Weibull distribution with scale parameter \eqn{p2*a^2/(b*\sigma*cos\theta*Hv)} and shape parameter
\eqn{p3} where \eqn{\sigma} denotes the stress, \eqn{a} the minor axis length and
\eqn{Hv} the Vickers hardness. The angle \eqn{\theta} is measured between the rotational axis 
and the axis of main load direction. In this way we account for the orientation of particles (spheroids)
when generating fracture times dependent on their tendency to be more or less oriented towards the 
main load direction.
}
\author{
Felix Ballani
}
\seealso{
\code{\link{getDelamTime}}
}

