% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generators.R
\name{vgamma}
\alias{vgamma}
\title{Variate Generation for Gamma Distribution}
\usage{
vgamma(
  n,
  shape,
  rate = 1,
  scale = 1/rate,
  stream = NULL,
  antithetic = FALSE,
  asList = FALSE
)
}
\arguments{
\item{n}{number of observations}

\item{shape}{Shape parameter}

\item{rate}{Alternate parameterization for scale}

\item{scale}{Scale parameter}

\item{stream}{if \code{NULL} (default), uses \code{\link[=runif]{stats::runif}}
to generate uniform variates to invert via 
\code{\link[=qgamma]{stats::qgamma}};
otherwise, an integer in 1:25 indicates the \code{\link{rstream}} stream
from which to generate uniform variates to invert via
\code{\link[=qgamma]{stats::qgamma}};}

\item{antithetic}{if \code{FALSE} (default), inverts \eqn{u} = uniform(0,1)
variate(s) generated via either \code{\link[=runif]{stats::runif}} or
\code{\link[=rstream.sample]{rstream::rstream.sample}}; otherwise, uses
\eqn{1 - u}}

\item{asList}{if \code{FALSE} (default), output only the generated
random variates; otherwise, return a list with components suitable for
visualizing inversion. See return for details}
}
\value{
If \code{asList} is FALSE (default), return a vector of random variates.

  Otherwise, return a list with components suitable for visualizing inversion,
  specifically:
    \item{u}{        A vector of generated U(0,1) variates }
    \item{x}{        A vector of gamma random variates }
    \item{quantile}{ Parameterized quantile function }
    \item{text}{     Parameterized title of distribution }
}
\description{
Variate Generation for Gamma Distribution
}
\details{
Generates random variates from the gamma distribution.

  Gamma variates are generated by inverting uniform(0,1) variates
  produced either by \code{\link[=runif]{stats::runif}} (if \code{stream} is
  \code{NULL}) or by \code{\link[=rstream.sample]{rstream::rstream.sample}}
  (if \code{stream} is not \code{NULL}).
  In either case, \code{\link[=qgamma]{stats::qgamma}} is used to
  invert the uniform(0,1) variate(s).
  In this way, using \code{vgamma} provides a monotone and synchronized
  binomial variate generator, although not particularly fast.

  The stream indicated must be an integer between 1 and 25 inclusive.

The gamma distribution with parameters \code{shape} = \eqn{a} and
    \code{scale} = \eqn{s} has density

         \deqn{f(x) = \frac{1}{s^a\, \Gamma(a)} x^{a-1} e^{-x/s}}{%
               f(x) = 1/(s^a Gamma(a)) x^(a-1) e^(-x/s)}

    for \eqn{x \ge 0}, \eqn{a > 0}, and \eqn{s > 0}.
    (Here \eqn{\Gamma(a)}{Gamma(a)} is the function implemented by
    R's \code{\link[base:Special]{gamma}()} and defined in its help.)

    The population mean and variance are \eqn{E(X) = as}
    and \eqn{Var(X) = as^2}.
}
\examples{
 set.seed(8675309)
 # NOTE: following inverts rstream::rstream.sample using stats::qgamma
 vgamma(3, shape = 2, rate = 1)

 set.seed(8675309)
 # NOTE: following inverts rstream::rstream.sample using stats::qgamma
 vgamma(3, 2, scale = 1, stream = 1)
 vgamma(3, 2, scale = 1, stream = 2)

 set.seed(8675309)
 # NOTE: following inverts rstream::rstream.sample using stats::qgamma
 vgamma(1, 2, scale = 1, stream = 1)
 vgamma(1, 2, scale = 1, stream = 2)
 vgamma(1, 2, scale = 1, stream = 1)
 vgamma(1, 2, scale = 1, stream = 2)
 vgamma(1, 2, scale = 1, stream = 1)
 vgamma(1, 2, scale = 1, stream = 2)

 set.seed(8675309)
 variates <- vgamma(1000, 2, scale = 1, stream = 1)
 set.seed(8675309)
 variates <- vgamma(1000, 2, scale = 1, stream = 1, antithetic = TRUE)

}
\seealso{
\code{\link{rstream}}, \code{\link{set.seed}},
         \code{\link[=runif]{stats::runif}}

\code{\link[=rgamma]{stats::rgamma}}
}
\author{
Barry Lawson (\email{blawson@richmond.edu}), \cr
   Larry Leemis (\email{leemis@math.wm.edu}), \cr
   Vadim Kudlay (\email{vadim.kudlay@richmond.edu})
}
\concept{random variate generation}
\keyword{distribution}
