% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/queuePlotting.R
\name{defaultPlotSSQ}
\alias{defaultPlotSSQ}
\title{Default SSQ Plotting Function}
\usage{
defaultPlotSSQ(
  time,
  currSystem,
  newDropped = 0,
  nextToEnter = 0,
  newServed = 0,
  currProgress,
  numRejects = 0,
  svctime,
  iartime,
  title = "",
  getPicFcn = function(i) return(NA)
)
}
\arguments{
\item{time}{The current time of the simulation}

\item{currSystem}{A vector of numbers listing the jobs in the current queue and
server, ordered from first (the job in service) to last (the most recent)
job to enter the queue.}

\item{newDropped}{Number of a job that was just dropped/rejected due to
queue reaching capacity. This will be plotted in the rejection pathway.}

\item{nextToEnter}{Number of the next job that will enter the queue.}

\item{newServed}{Number of a job that just finished being serviced.}

\item{currProgress}{Number quantifying current progress of simulation in [0,1]}

\item{numRejects}{Number of jobs rejected from queue so far}

\item{svctime}{Current service time of job in service}

\item{iartime}{Current interarrival time of next job to enter}

\item{title}{Title of visualization}

\item{getPicFcn}{Function to return the an image of the ith job.
Should return a raster image if an image exists, or \code{NA} otherwise}
}
\description{
This function plots a visualization of a single-queue
   single-server system.
}
\details{
Generates a snapshot plot of the queue with states specified in parameters. \cr
   This is a default plotting function in \code{ssq()}
}
\author{
Barry Lawson (\email{blawson@richmond.edu}), \cr
   Larry Leemis (\email{leemis@math.wm.edu}), \cr
   Vadim Kudlay (\email{vadim.kudlay@richmond.edu})
}
\concept{queueing}
\keyword{internal}
