\name{vweibull}
\alias{vweibull}
\alias{Weibull}

\title{Variate Generator for the Weibull Distribution}
\description{
  Generates random variates from the Weibull distribution, with options for
  independent streams and antithetic variates.
}
\usage{
  vweibull(n, shape, scale = 1, stream = NULL, antithetic = FALSE)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{n}{number of observations}
  \item{shape, scale}{shape and scale parameters (must be positive)}
  \item{stream}{if \code{NULL} (default), uses \code{\link[=runif]{stats::runif}}
    to generate uniform variates to invert via \code{\link[=qweibull]{stats::qweibull}}; 
    otherwise, an integer in 1:25 indicates the \code{\link{rstream}} stream
    from which to generate uniform variates to invert via
    \code{\link[=qweibull]{stats::qweibull}}}
  \item{antithetic}{if \code{FALSE} (default), inverts \eqn{u} = uniform(0,1)
    variate(s) generated via either \code{\link[=runif]{stats::runif}} or
    \code{\link[=rstream.sample]{rstream::rstream.sample}}; otherwise, uses
    \eqn{1 - u}}
}
\details{
  Generates random variates from the Weibull distribution.

  Weibull variates are generated by inverting uniform(0,1) variates
  produced either by \code{\link[=runif]{stats::runif}} (if \code{stream} is
  \code{NULL}) or by \code{\link[=rstream.sample]{rstream::rstream.sample}} (if
  \code{stream} is not \code{NULL}).
  In either case, \code{\link[=qweibull]{stats::qweibull}} is used to invert the
  uniform(0,1) variate(s).
  In this way, using \code{vweibull} provides a monotone and synchronized
  Weibull variate generator, although not particularly fast.

  The stream indicated must be an integer between 1 and 25 inclusive.

  If \code{scale} is omitted, it assumes the default value of 1.

  The Weibull distribution with parameters \code{shape =} \eqn{a} and 
  \code{scale =} \eqn{s} has density

      \deqn{f(x) = (a/b) (x/b)^(a-1) exp(- (x/b)^a)}

   for \eqn{x \ge 0}, \eqn{a > 0}, and \eqn{s > 0}.
}
\value{
  A vector of Weibull random variates.
}
\seealso{
    \code{\link[=rweibull]{stats::rweibull}}, \code{\link[=runif]{stats::runif}},
    \code{\link{rstream}}, \code{\link{set.seed}}
}
\author{Barry Lawson (\email{blawson@richmond.edu}), 
        Larry Leemis (\email{leemis@math.wm.edu})}
\examples{
set.seed(8675309)
vweibull(3, shape = 2, scale = 1)  # inverts stats::runif using stats::qweibull

set.seed(8675309)
vweibull(3, shape = 2, scale = 1, stream = 1)  # inverts rstream.sample using stats::qweibull
vweibull(3, shape = 2, scale = 1, stream = 2)

set.seed(8675309)
vweibull(1, shape = 2, scale = 1, stream = 1)  # inverts rstream.sample using stats::qweibull
vweibull(1, shape = 2, scale = 1, stream = 2)
vweibull(1, shape = 2, scale = 1, stream = 1)
vweibull(1, shape = 2, scale = 1, stream = 2)
vweibull(1, shape = 2, scale = 1, stream = 1)
vweibull(1, shape = 2, scale = 1, stream = 2)

set.seed(8675309)
variates <- vweibull(1000, shape = 2, scale = 1, stream = 1)
set.seed(8675309)
variates <- vweibull(1000, shape = 2, scale = 1, stream = 1, antithetic = TRUE)
}
\keyword{distribution}  % RShowDoc("KEYWORDS") for suggested list
\concept{random variate generation}
