% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Estimate.R
\name{estimate_Rs_for_islandLocations}
\alias{estimate_Rs_for_islandLocations}
\title{Estimating solar radiation for island locations}
\usage{
estimate_Rs_for_islandLocations(Ra, b = 4)
}
\arguments{
\item{Ra}{extraterrestrial radiation [MJ m-2 day-1].}

\item{b}{empirical constant, equal to 4 MJ m-2 day-1.}
}
\value{
A vector for solar radiation
}
\description{
For island locations, where the land mass has a width
   perpendicular to the coastline of 20 km or less, the air masses influencing
   the atmospheric conditions are dominated by the adjacent water body in all
   directions. The temperature method is not appropriate for this situation.
   Where radiation data from another location on the island are not available,
   a first estimate of the monthly solar average can be obtained from the
   empirical relation.
}
\note{
This relationship is only applicable for low altitudes (from 0 to 100 m).
   The empirical constant represents the fact that in island locations some
   clouds are usually present, thus making the mean solar radiation 4 MJ m-2 day-1
   below the nearly clear sky envelope (0.7 Ra). Local adjustment of the
   empirical constant may improve the estimation. The method is only appropriate
   for monthly calculations. The constant relation between Rs and Ra does not
   yield accurate daily estimates.
}
\references{
Allen, R. G., Pereira, L. S., Raes, D., & Smith, M.
   FAO Irrigation and drainage paper No. 56. Rome: Food and Agriculture
   Organization of the United Nations, 1998.
}
