% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Estimate.R
\name{estimate_ea}
\alias{estimate_ea}
\title{Estimating missing humidity data}
\usage{
estimate_ea(Tmin)
}
\arguments{
\item{Tmin}{the minimum tem daily.}
}
\value{
A vector for humidity
}
\description{
Where humidity data are lacking or are of questionable quality,
   an estimate of actual vapour pressure, ea, can be obtained by assuming
   that dewpoint temperature (Tdew) is near the daily minimum temperature (Tmin).
   This statement implicitly assumes that at sunrise, when the air temperature
   is close to Tmin, that the air is nearly saturated with water vapour and
   the relative humidity is nearly 100 \%.
}
\note{
The relationship Tdew near Tmin holds for locations where the cover
   crop of the station is well watered. However, particularly for arid regions,
   the air might not be saturated when its temperature is at its minimum.
   Hence, Tmin might be greater than Tdew and a further calibration may be
   required to estimate dewpoint temperatures. In these situations, "Tmin" in
   the above equation may be better approximated by subtracting 2-3 degrees
   Celsius from Tmin. Appropriate correction procedures are given in Annex 6.
   In humid and subhumid climates, Tmin and Tdew measured in early morning
   may be less than Tdew measured during the daytime because of condensation
   of dew during the night.  After sunrise, evaporation of the dew will once
   again humidify the air and will increase the value measured for Tdew
   during the daytime. This phenomenon is demonstrated in Figure 5.4 of Annex 5.
   However, it is standard practice in 24-hour calculations of ETo to use
   Tdew measured or calculated durin early morning. The estimate for ea from
   Tmin should be checked. When the prediction by Equation 48 is validated
   for a region, it can be used for daily estimates of ea.
}
\references{
Allen, R. G., Pereira, L. S., Raes, D., & Smith, M.
   FAO Irrigation and drainage paper No. 56. Rome: Food and Agriculture
   Organization of the United Nations, 1998.
}
