% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_Shuttleworth_Wallace.R
\name{cal_soilSurfaceResistance}
\alias{cal_soilSurfaceResistance}
\title{Calculating soil surface resistance}
\usage{
cal_soilSurfaceResistance(
  tau,
  l,
  PHI_p,
  Dm_v,
  lambda_p,
  THETA_v_l,
  THETA_v_sat_l
)
}
\arguments{
\item{tau}{soil tortuosity (taken as 2)}

\item{l}{is the dry soil layer thickness (taken as the first soil layer thickness) (m)}

\item{PHI_p}{is soil porosity}

\item{Dm_v}{the vapor diffusion coefficient in air (24.7  10-6 m2 s-1)}

\item{lambda_p}{the soil pore-size distribution index from the Brooks-Corey equation.}

\item{THETA_v_l}{volumetric soil water content (m-3 m-3) of the first soil layer}

\item{THETA_v_sat_l}{saturated soil water content (m3 m-3) of the first soil layer}
}
\value{
A vector for the soil surface resistance (s m-1)
}
\description{
Calculating soil surface resistance
}
