% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim2D_RandSet_HPPP.R
\name{sim2D_RandSet_HPPP}
\alias{sim2D_RandSet_HPPP}
\title{Generate a Random Set Using a Poisson Process and Random Radii About Events}
\usage{
sim2D_RandSet_HPPP(
  N,
  xlim = c(0, 1),
  ylim = c(0, 1),
  radius.bounds = c(0.05, 0.15),
  lambda = 50,
  lambda.sd = 10,
  lambda.bound = NULL,
  prior = "gamma",
  random.lambda = FALSE,
  sub.area = TRUE,
  min.sa = c(0.1, 0.1),
  max.sa = c(0.3, 0.3),
  radius.bounds.min.sa = c(0.02, 0.05),
  radius.bounds.max.sa = c(0.08, 0.15),
  print.subj.sa = FALSE,
  print.lambda = FALSE,
  print.iter = FALSE
)
}
\arguments{
\item{N}{A scalar value determining the number of images to create.}

\item{xlim, ylim}{These are the 2D image limits. Defaults for both are \code{c(0, 1)}.
It is not recommended to alter these arguments unless changing the limits has a
specific practical utility.}

\item{radius.bounds}{A 2-element vector whose first and second entries determine
the minimum and maximum radius sizes, respectively; these will be the bounds
of the uniform distribution used to draw the radii. If \code{sub.area = TRUE}, then
use \code{radius.bounds.min.sa} and \code{radius.bounds.max.sa}.}

\item{lambda}{A scalar value specifying the mean/intensity value of the Poisson process.
If \code{random.lambda = FALSE} then this is the parameter used to generate the binary
image for each subject. If \code{random.lambda = TRUE}, then this is the mean parameter
in the distribution used to draw subject-specific lambda.}

\item{lambda.sd}{Only utilized when \code{random.lambda = TRUE}, and specifies the
standard deviation in the distribution used to draw subject-specific lambda.}

\item{lambda.bound}{Only utilized when \code{random.lambda = TRUE}, and allows the
user to specify a lower and upper bound for the subject-specific lambda; if the
randomly selected value is outside of this range, then another draw is taken. This
continues until a value is selected within the specified bounds. If no bounds are
desired then specify \code{lambda.bound = NULL}.}

\item{prior}{Only utilized when \code{random.lambda = TRUE}, and specifies the
distribution from which to draw the subject-specific lambda.
Options are \code{c("gaussian", "gamma")}.}

\item{random.lambda}{\code{random.lambda = TRUE} allows the lambda (mean/intensity)
parameter in the Poisson process to vary randomly by subject.}

\item{sub.area}{When \code{sub.area = TRUE}, a random sub-section of the image is
chosen, within which the Poisson process is used to generate the binary image.}

\item{min.sa, max.sa}{Only utilized when \code{sub.area = TRUE}, and
determines the width and height of the  minimum and maximum sub-areas; e.g., if
\code{min.sa = c(0.1, 0.1)}, then the smallest possible random sub-area is a
0.1 x 0.1 square.}

\item{radius.bounds.min.sa, radius.bounds.max.sa}{Only utilized when \code{sub.area = TRUE}, and
specifies \code{radius.bounds} for the minimum and maximum sub-areas, respectively.
This information is used to adaptively alter the bounds in between the minimum and maximum
sub-areas.}

\item{print.subj.sa, print.lambda, print.iter}{These arguments are either
\code{TRUE} or \code{FALSE}, and define print options for checking that the
function is working as the user intends. \code{print.subj.sa = TRUE} prints the x-
and y-limits for each subject's sub-area. \code{print.lambda = TRUE} prints each
subject's mean and realized events; the means will be the same unless \code{random.lambda = TRUE},
but the number of realized events will always vary. \code{print.iter = TRUE} is
only used when \code{random.lambda = TRUE} and \code{is.null(lambda.bound) = FALSE},
and shows iterations for re-drawing when the randomly selected intensity is outside
the specified bounds.}
}
\value{
A dataframe with columns for subject ID, x-coordinates, y-coordinates,
and associated radii.
}
\description{
A random set is generated by using a Poisson process in 2D space to choose
'event' locations, about which a circle of random radius is 'drawn'. The union
of the circles defines ultimately defines the set.
}
\references{
\insertRef{Cressie+Wikle:2011}{sim2Dpredictr}
}
