% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TRI-model.R, R/plot.R
\name{TRI}
\alias{TRI}
\alias{plot.TRI}
\title{TRI model, triangulations}
\usage{
TRI(x, ...)

\method{plot}{TRI}(x, ..., add = FALSE)
}
\arguments{
\item{x}{object understood by silicate (sf, sp, a silicate model, etc.)}

\item{...}{current unused}

\item{add}{logical create  new plot (default), or add to existing}
}
\value{
TRI model with tables 'object', 'triangle', 'vertex'
}
\description{
TRI creates a constrained triangulation using 'ear-cutting', or 'ear-clipping' of
polygons. The model is a 'relational' form in that the underlying tables are
linked implicitly by unique identifiers.
Ear-cutting is inherently path-based, so this model is only available for
path-based structures, like simple features, \code{\link[=PATH]{PATH()}}, \code{\link[=PATH0]{PATH0()}} and \code{\link[=ARC]{ARC()}}.
}
\examples{
tri <- TRI(minimal_mesh)
plot(tri)
}
